/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.entities.transfer;

import br.com.moip.android.entities.financial.CreditedBankAccount;
import br.com.moip.android.entities.transfer.TransferStatus;
import br.com.moip.android.entities.transfer.TransferStatusLog;
import br.com.moip.android.helper.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Transfer {
    private String id;
    private String moipAccountId;
    private String moipAccount;
    private String bankAccountId;
    private String bankAccount;
    private Integer amount;
    private TransferStatus status;
    private Integer fee;
    private Calendar createdAt;
    private Calendar updatedAt;
    private String externalId;
    private CreditedBankAccount creditedBankAccount;
    private List<TransferStatusLog> statusLog;

    public Transfer() {
        this.createdNow();
    }

    public void createdNow() {
        Calendar now;
        this.createdAt = now = Date.currentDateTime();
        this.updatedAt = now;
    }

    public void updatedNow() {
        this.updatedAt = Date.currentDateTime();
    }

    public TransferStatus getStatus() {
        return this.status;
    }

    public boolean moipAccountIs(String moipAccount) {
        try {
            return this.moipAccount.equals(moipAccount);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getMoipAccountId() {
        return this.moipAccountId;
    }

    public void setMoipAccountId(String moipAccountId) {
        this.moipAccountId = moipAccountId;
    }

    public String getMoipAccount() {
        return this.moipAccount;
    }

    public void setMoipAccount(String moipAccount) {
        this.moipAccount = moipAccount;
    }

    public String getBankAccountId() {
        return this.bankAccountId;
    }

    public void setBankAccountId(String bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Integer getFee() {
        return this.fee;
    }

    public void setFee(Integer fee) {
        this.fee = fee;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Calendar createdAt) {
        this.createdAt = createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Calendar updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getPK() {
        return this.getId();
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public boolean isRequested() {
        return TransferStatus.REQUESTED == this.getStatus();
    }

    public boolean isFailed() {
        return TransferStatus.FAILED == this.getStatus();
    }

    public boolean isConluded() {
        return TransferStatus.COMPLETED == this.getStatus();
    }

    public void conclude() {
        if (TransferStatus.COMPLETED.equals((Object)this.status)) {
            return;
        }
        if (!this.isRequested()) {
            throw new IllegalArgumentException("Cannot change status from " + (Object)((Object)this.getStatus()) + " to COMPLETED");
        }
        this.status = TransferStatus.COMPLETED;
    }

    public void fail() {
        this.status = TransferStatus.FAILED;
    }

    public void setStatus(TransferStatus newStatus) {
        if (TransferStatus.COMPLETED.equals((Object)newStatus)) {
            this.conclude();
        } else {
            this.fail();
        }
    }

    public CreditedBankAccount getCreditedBankAccount() {
        return this.creditedBankAccount;
    }

    public void setCreditedBankAccount(CreditedBankAccount creditedBankAccount) {
        this.creditedBankAccount = creditedBankAccount;
    }

    public List<TransferStatusLog> getStatusLog() {
        return this.statusLog;
    }

    public void setStatusLog(List<TransferStatusLog> statusLog) {
        this.statusLog = statusLog;
    }

    public void addStatusLog(TransferStatus status, Calendar date) {
        if (this.statusLog == null) {
            this.statusLog = new ArrayList<TransferStatusLog>();
        }
        TransferStatusLog log = new TransferStatusLog();
        log.setStatus(status);
        log.setCreatedAtDate(date);
        log.setCreatedAtTime(date.getTime());
        log.setTransfer(this);
        this.statusLog.add(log);
    }
}

