/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.helper;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;

public class Cents {
    private static BigDecimal BIG_CENT = BigDecimal.valueOf(100L);

    public static int toCents(BigDecimal val) {
        if (val != null) {
            return val.multiply(BIG_CENT).intValue();
        }
        return 0;
    }

    public static long toLongCents(BigDecimal val) {
        if (val != null) {
            return val.multiply(BIG_CENT).longValue();
        }
        return 0L;
    }

    public static BigDecimal fromCents(Integer val) {
        if (val != null) {
            return BigDecimal.valueOf(val.intValue()).divide(BIG_CENT);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal fromCents(Long val) {
        if (val != null) {
            return BigDecimal.valueOf(val).divide(BIG_CENT);
        }
        return BigDecimal.ZERO;
    }

    public static String toReal(int val) {
        BigDecimal bigDecimal = new BigDecimal(val);
        return Cents.toReal(bigDecimal);
    }

    public static String toReal(long val) {
        BigDecimal bigDecimal = new BigDecimal(val);
        return Cents.toReal(bigDecimal);
    }

    public static String toReal(BigDecimal val) {
        return NumberFormat.getCurrencyInstance(new Locale("pt", "BR")).format(val.divide(BIG_CENT));
    }
}

