/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.helper;

import br.com.moip.android.exception.MoIPSDKException;
import br.com.moip.android.type.CreditCardBrand;

public class MoIPUtils {
    public static boolean isValidCreditCard(String ccNumber) {
        int sum = 0;
        boolean alternate = false;
        for (int i = ccNumber.length() - 1; i >= 0; --i) {
            int n = Integer.parseInt(ccNumber.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }

    public static CreditCardBrand verifyBrand(String ccNumber) {
        if (ccNumber.matches("^4[0-9]{12}(?:[0-9]{3})?$")) {
            return CreditCardBrand.VISA;
        }
        if (ccNumber.matches("^5[1-5][0-9]{14}$")) {
            return CreditCardBrand.MASTERCARD;
        }
        if (ccNumber.matches("^3[47][0-9]{13}$")) {
            return CreditCardBrand.AMEX;
        }
        if (ccNumber.matches("^3(?:0[0-5]|[68][0-9])[0-9]{11}$")) {
            return CreditCardBrand.DINERS;
        }
        return CreditCardBrand.UNKNOWN;
    }

    public static CreditCardBrand quicklyBrand(String ccNumber) {
        if (ccNumber.length() < 2) {
            return CreditCardBrand.UNKNOWN;
        }
        Integer range = Integer.valueOf(ccNumber.substring(0, 2));
        if (range >= 40 && range <= 49) {
            return CreditCardBrand.VISA;
        }
        if (range >= 50 && range <= 59) {
            return CreditCardBrand.MASTERCARD;
        }
        if (range == 34 || range == 37) {
            return CreditCardBrand.AMEX;
        }
        if (range == 60 || range == 62 || range == 64 || range == 65) {
            return CreditCardBrand.DISCOVERY;
        }
        if (range == 35) {
            return CreditCardBrand.JCB;
        }
        if (range == 30 || range == 36 || range == 38 || range == 39) {
            return CreditCardBrand.DINERS;
        }
        return CreditCardBrand.UNKNOWN;
    }

    public static boolean isValidCVC(String cvc) {
        return MoIPUtils.isNumber(cvc) && Integer.parseInt(cvc) >= 100 && Integer.parseInt(cvc) <= 9999;
    }

    public static boolean isValidMonth(Integer expirationMonth) {
        System.out.println(expirationMonth);
        return expirationMonth > 0 && expirationMonth < 13;
    }

    public static boolean isValidYear(Integer expirationYear) {
        System.out.println(expirationYear);
        return expirationYear > 0 && expirationYear < 99;
    }

    private static boolean isNumber(String text) {
        return text.matches("[0-9]+");
    }

    public static String justNumber(String text) throws MoIPSDKException {
        String number = text.replace("-", "").replace(" ", "").replace("(", "").replace(")", "").replace(".", "").replace(",", "");
        if (number.matches("[0-9]+")) {
            return number;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Wrong format ");
        sb.append(text);
        throw new MoIPSDKException(sb.toString(), new NumberFormatException());
    }

    public static boolean isValidCPF(String strCpf) {
        int d2 = 0;
        int d1 = 0;
        int resto = 0;
        int digito2 = 0;
        int digito1 = 0;
        for (int nCount = 1; nCount < strCpf.length() - 1; ++nCount) {
            int digitoCPF = Integer.valueOf(strCpf.substring(nCount - 1, nCount));
            d1 += (11 - nCount) * digitoCPF;
            d2 += (12 - nCount) * digitoCPF;
        }
        resto = d1 % 11;
        digito1 = resto < 2 ? 0 : 11 - resto;
        resto = (d2 += 2 * digito1) % 11;
        digito2 = resto < 2 ? 0 : 11 - resto;
        String nDigVerific = strCpf.substring(strCpf.length() - 2, strCpf.length());
        String nDigResult = String.valueOf(digito1) + String.valueOf(digito2);
        return nDigVerific.equals(nDigResult);
    }

    public static boolean isValidEmail(String email) {
        return email.matches(".+@.+\\.[a-z]+");
    }
}

