/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.helper;

import android.content.Context;
import android.content.SharedPreferences;
import br.com.moip.android.entities.account.Account;
import br.com.moip.authentication.Authentication;
import br.com.moip.authentication.BasicAuth;
import br.com.moip.authentication.OAuth;
import com.google.gson.Gson;
import java.util.Map;

public class MoipSharedPreferences {
    private Context instance;
    private SharedPreferences prefs;
    private SharedPreferences.Editor editor;
    private static final String MOIP = "moip";
    private static final String OAUTH = "oauth";
    private static final String TOKEN = "token";
    private static final String PASSWORD = "password";
    private static final String ENVIRONMENT = "environment";
    private static final String EXTERNAL_ID = "external-id";
    private static final String PUBLIC_KEY = "public-key";
    private static final String APP_ID = "appId";
    private static final String APP_SECRET = "appSecret";
    private static final String EMAIL = "email";
    private static final String ACCOUNT = "account";
    private static final String SOFTDESCRIPTOR = "softDescriptor";
    private static final String TWO_FACTOR_AUTHENTICATION_TOKEN = "twoFactorAuthenticationToken";
    private static final String TWO_FACTOR_AUTHENTICATION_ID = "twoFactorAuthenticationId";
    private static MoipSharedPreferences moipSharedPreferences;

    public MoipSharedPreferences(Context context) {
        this.instance = context;
        this.prefs = this.instance.getSharedPreferences(MOIP, 0);
        this.editor = this.instance.getSharedPreferences(MOIP, 0).edit();
    }

    @Deprecated
    public static MoipSharedPreferences setInstance(Context context) {
        if (moipSharedPreferences == null) {
            moipSharedPreferences = new MoipSharedPreferences(context);
        }
        return moipSharedPreferences;
    }

    @Deprecated
    public static MoipSharedPreferences getInstance() {
        return moipSharedPreferences;
    }

    public void saveOldPreferences() {
        Map allEntries = this.prefs.getAll();
        for (Map.Entry entry : allEntries.entrySet()) {
            this.editor.putString((String)entry.getKey(), this.prefs.getString((String)entry.getKey(), null));
        }
    }

    public boolean saveOauth(String oauth) {
        return this.savePreference(OAUTH, oauth);
    }

    public boolean sandbox() {
        return this.saveEnvironment("sandbox");
    }

    public boolean production() {
        return this.saveEnvironment("production");
    }

    private boolean saveEnvironment(String key) {
        return this.savePreference(ENVIRONMENT, key);
    }

    public boolean saveExternalId(String externalId) {
        return this.savePreference(EXTERNAL_ID, externalId);
    }

    public boolean savePublicKey(String publicKey) {
        return this.savePreference(PUBLIC_KEY, publicKey);
    }

    public boolean saveBasicAuth(String token, String password) {
        this.savePreference(TOKEN, token);
        return this.savePreference(PASSWORD, password);
    }

    public boolean saveAppInfo(String appId, String appSecret) {
        this.savePreference(APP_ID, appId);
        return this.savePreference(APP_SECRET, appSecret);
    }

    public boolean saveEmail(String key) {
        return this.savePreference(EMAIL, key);
    }

    public boolean saveAccount(Account account) {
        return this.savePreference(ACCOUNT, new Gson().toJson((Object)account));
    }

    public boolean saveAuthentication(Authentication auth) {
        if (auth instanceof BasicAuth) {
            return this.saveBasicAuth(((BasicAuth)auth).getToken(), ((BasicAuth)auth).getKey());
        }
        if (auth instanceof OAuth) {
            return this.saveOauth(((OAuth)auth).getAccessToken());
        }
        return false;
    }

    public String getOauth() {
        return this.getPreference(OAUTH);
    }

    public String getExternalId() {
        return this.getPreference(EXTERNAL_ID);
    }

    public String getEnvironment() {
        return this.getPreference(ENVIRONMENT);
    }

    public String getToken() {
        return this.getPreference(TOKEN);
    }

    public String getPassword() {
        return this.getPreference(PASSWORD);
    }

    public String getPublicKey() {
        return this.getPreference(PUBLIC_KEY);
    }

    public String getAppId() {
        return this.getPreference(APP_ID);
    }

    public String getAppSecret() {
        return this.getPreference(APP_SECRET);
    }

    public String getEmail() {
        return this.getPreference(EMAIL);
    }

    public String getTwoFactorAuthenticationToken() {
        return this.getPreference(TWO_FACTOR_AUTHENTICATION_TOKEN);
    }

    public String getTwoFactorAuthenticationId() {
        return this.getPreference(TWO_FACTOR_AUTHENTICATION_ID);
    }

    public Account getAccount() {
        if (this.prefs.contains(ACCOUNT)) {
            return (Account)new Gson().fromJson(this.prefs.getString(ACCOUNT, null), Account.class);
        }
        return null;
    }

    public Authentication getAuthentication() {
        if (this.getOauth() != null) {
            return new OAuth(this.getOauth());
        }
        if (this.getToken() != null && this.getPassword() != null) {
            return new BasicAuth(this.getToken(), this.getPassword());
        }
        return null;
    }

    public boolean isSandbox() {
        return "sandbox".equals(this.getEnvironment());
    }

    public boolean isProduction() {
        return "production".equals(this.getEnvironment());
    }

    public void clear() {
        String environment = this.getEnvironment();
        String appId = this.getAppId();
        String appSecret = this.getAppSecret();
        this.editor.clear();
        this.editor.commit();
        this.saveEnvironment(environment);
        this.saveAppInfo(appId, appSecret);
    }

    public void clear(String what) {
        this.editor.remove(what);
        this.editor.commit();
    }

    public boolean isLogged() {
        return this.prefs.contains(OAUTH) && this.prefs.contains(EXTERNAL_ID);
    }

    public boolean hasBasicAuth() {
        return this.prefs.contains(TOKEN) && this.prefs.contains(PASSWORD);
    }

    private boolean savePreference(String key, String value) {
        this.saveOldPreferences();
        this.editor.putString(key, value);
        return this.editor.commit();
    }

    private String getPreference(String key) {
        return this.prefs.getString(key, null);
    }

    public boolean saveTwoFactorAuthenticationToken(String twoFactorAuthenticationToken) {
        return this.savePreference(TWO_FACTOR_AUTHENTICATION_TOKEN, twoFactorAuthenticationToken);
    }

    public boolean saveTwoFactorAuthenticationId(String twoFactorAuthenticationId) {
        return this.savePreference(TWO_FACTOR_AUTHENTICATION_ID, twoFactorAuthenticationId);
    }

    public boolean saveSoftDescriptor(String softDescriptor) {
        return this.savePreference(SOFTDESCRIPTOR, softDescriptor);
    }

    public String getSoftDescriptor() {
        return this.getPreference(SOFTDESCRIPTOR);
    }

    public boolean hasSoftDescriptor() {
        return this.getSoftDescriptor() != null && !this.getSoftDescriptor().trim().isEmpty();
    }

    public boolean hasTwoFactorAuthenticationToken() {
        return this.getTwoFactorAuthenticationId() != null && this.getTwoFactorAuthenticationToken() != null;
    }
}

