/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.old;

import android.content.Context;
import android.util.Log;
import br.com.moip.android.callback.old.MoipCallback;
import br.com.moip.android.communication.FeignClientBuilder;
import br.com.moip.android.communication.adapter.DateTypeAdapter;
import br.com.moip.android.communication.api.AccountAPI;
import br.com.moip.android.communication.api.CustomerAPI;
import br.com.moip.android.communication.api.InvoiceAPI;
import br.com.moip.android.communication.api.OrderAPI;
import br.com.moip.android.communication.api.PaymentAPI;
import br.com.moip.android.communication.api.ReimburseAPI;
import br.com.moip.android.entities.account.Account;
import br.com.moip.android.entities.customer.Customer;
import br.com.moip.android.entities.invoice.Invoice;
import br.com.moip.android.entities.order.Order;
import br.com.moip.android.entities.order.Payment;
import br.com.moip.android.entities.reimburse.RefundRequest;
import br.com.moip.android.exception.MoIPSDKException;
import br.com.moip.android.exception.MoipError;
import br.com.moip.android.helper.MoipSharedPreferences;
import br.com.moip.android.parser.MoipErrorParser;
import br.com.moip.android.security.KeyManager;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class Moip {
    public static void initialize(Context context) {
        MoipSharedPreferences.setInstance(context);
    }

    public static void Environment(String environment) {
    }

    public static void BasicAuth(String token, String password) {
        MoipSharedPreferences.getInstance().saveBasicAuth(token, password);
    }

    public static void AppInfo(String appId, String appSecret) {
        MoipSharedPreferences.getInstance().saveAppInfo(appId, appSecret);
    }

    public static void PublicKey(String publicKey) throws MoIPSDKException {
        MoipSharedPreferences.getInstance().savePublicKey(publicKey);
        KeyManager.clearInstance();
        try {
            KeyManager.newInstance(publicKey);
        }
        catch (InvalidKeySpecException e) {
            throw new MoIPSDKException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MoIPSDKException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new MoIPSDKException(e);
        }
        catch (IOException e) {
            throw new MoIPSDKException(e);
        }
        catch (NoSuchProviderException e) {
            throw new MoIPSDKException(e);
        }
    }

    public static void createPayment(Payment payment, MoipCallback<Payment> moipCallback) {
        PaymentAPI paymentAPI = new FeignClientBuilder().getApi(PaymentAPI.class);
        String id2 = payment.getMoipOrderID();
        Payment createdPayment = null;
        try {
            createdPayment = paymentAPI.createPayment(payment, id2);
            moipCallback.success(createdPayment);
        }
        catch (MoIPSDKException mde) {
            List<MoipError> moipErrorList = new MoipErrorParser().fromString(mde.getMessage());
            moipCallback.failure(moipErrorList);
        }
    }

    public static void createOrder(Order order, MoipCallback<Order> moipCallback) {
        OrderAPI orderAPI = new FeignClientBuilder().getApi(OrderAPI.class);
        Order createdOrder = null;
        try {
            createdOrder = orderAPI.createOrder(order);
            moipCallback.success(createdOrder);
        }
        catch (MoIPSDKException mde) {
            List<MoipError> moipErrorList = new MoipErrorParser().fromString(mde.getMessage());
            moipCallback.failure(moipErrorList);
        }
    }

    public static void createCustomer(Customer customer, MoipCallback<Customer> moipCallback) {
        CustomerAPI customerAPI = new FeignClientBuilder().getApi(CustomerAPI.class);
        Customer createdCustomer = null;
        try {
            createdCustomer = customerAPI.createCustomer(customer);
        }
        catch (MoIPSDKException mde) {
            List<MoipError> moipErrorList = new MoipErrorParser().fromString(mde.getMessage());
            moipCallback.failure(moipErrorList);
        }
        moipCallback.success(createdCustomer);
    }

    public static Order createMyOrder(Order order, String url) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
        String credentials = "JCVTBHJRXLGB7QA52VUKWQW7HRIZYRKL:ZWRDQ9VIGP3A9454N1UGLACXI60AOIWTGZMNJYIO";
        String base64EncodedCredentials = new String(Base64.encodeBase64((byte[])credentials.getBytes()));
        httpPost.setHeader("Authorization", "Basic " + base64EncodedCredentials);
        int TIMEOUT_MILLISEC = 10000;
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)TIMEOUT_MILLISEC);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)TIMEOUT_MILLISEC);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(gson.toJson((Object)order).toString()));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        System.out.println(responseBody);
        System.out.println(gson.fromJson(responseBody, Order.class));
        return (Order)gson.fromJson(responseBody, Order.class);
    }

    public static void createOrderOauth(Order order, MoipCallback<Order> moipCallback) {
        OrderAPI orderAPI = new FeignClientBuilder().getApiOAuth(OrderAPI.class);
        Order createdOrder = null;
        try {
            createdOrder = orderAPI.createOrder(order);
            moipCallback.success(createdOrder);
        }
        catch (MoIPSDKException mde) {
            List<MoipError> moipErrorList = new MoipErrorParser().fromString(mde.getMessage());
            moipCallback.failure(moipErrorList);
        }
    }

    public static void createPaymentOauth(Payment payment, MoipCallback<Payment> moipCallback) {
        PaymentAPI paymentAPI = new FeignClientBuilder().getApiOAuth(PaymentAPI.class);
        String id2 = payment.getMoipOrderID();
        Payment createdPayment = null;
        try {
            createdPayment = paymentAPI.createPayment(payment, id2);
            moipCallback.success(createdPayment);
        }
        catch (MoIPSDKException mde) {
            List<MoipError> moipErrorList = new MoipErrorParser().fromString(mde.getMessage());
            moipCallback.failure(moipErrorList);
        }
    }

    public static Account myAccount() {
        AccountAPI accountAPI = new FeignClientBuilder().getApiOAuth(AccountAPI.class);
        return accountAPI.getAccount(MoipSharedPreferences.getInstance().getExternalId());
    }

    public static void reimburse(Payment payment, MoipCallback<Boolean> moipCallback) {
        ReimburseAPI reimburseAPI = new FeignClientBuilder().getApi(ReimburseAPI.class);
        try {
            reimburseAPI.reimburse(new RefundRequest(payment.getFundingInstrument()), payment.getMoipOrderID());
            moipCallback.success(true);
        }
        catch (MoIPSDKException mde) {
            List<MoipError> moipErrorList = new MoipErrorParser().fromString(mde.getMessage());
            moipCallback.failure(moipErrorList);
        }
    }

    public static void reimburseOauth(Payment payment, MoipCallback<Boolean> moipCallback) {
        ReimburseAPI reimburseAPI = new FeignClientBuilder().getApiOAuth(ReimburseAPI.class);
        try {
            reimburseAPI.reimburse(new RefundRequest(payment.getFundingInstrument()), payment.getMoipOrderID());
            moipCallback.success(true);
        }
        catch (MoIPSDKException mde) {
            List<MoipError> moipErrorList = new MoipErrorParser().fromString(mde.getMessage());
            moipCallback.failure(moipErrorList);
        }
    }

    public static void createInvoice(Invoice invoice, MoipCallback<Invoice> moipCallback) {
        InvoiceAPI invoiceAPI = new FeignClientBuilder().getApi(InvoiceAPI.class);
        try {
            Invoice createdInvoice = invoiceAPI.createInvoice(invoice);
            moipCallback.success(createdInvoice);
        }
        catch (MoIPSDKException mde) {
            List<MoipError> moipErrorList = new MoipErrorParser().fromString(mde.getMessage());
            moipCallback.failure(moipErrorList);
        }
    }

    public static boolean enableMpos(Account account) {
        AccountAPI accountAPI = new FeignClientBuilder().getApiOAuth(AccountAPI.class);
        try {
            Log.i((String)"Enable mpos for ", (String)MoipSharedPreferences.getInstance().getExternalId());
            if (!Moip.canUseApp(account)) {
                throw new MoIPSDKException();
            }
            accountAPI.enableMpos(MoipSharedPreferences.getInstance().getExternalId());
        }
        catch (MoIPSDKException e) {
            Log.e((String)"enableMpos", (String)("Account " + MoipSharedPreferences.getInstance().getExternalId() + " is not ready for mpos"));
            return false;
        }
        return true;
    }

    private static boolean canUseApp(Account account) {
        return account.getV2IntegrationLevel() == 3;
    }
}

