/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.parser;

import br.com.moip.android.entities.order.Holder;
import br.com.moip.android.exception.MoIPSDKException;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class CardHolderParser {
    private JSONObject jsonCardHolder = new JSONObject();
    private final String FULL_NAME = "fullname";
    private final String BIRTHDATE = "birthdate";
    private final JSONObject jsonDocument;
    private final String TAX_DOCUMENT = "taxDocument";
    private final String DOCUMENT_NUMBER = "number";
    private String DOCUMENT_TYPE = "type";
    private JSONObject jsonPhone = new JSONObject();
    private final String PHONE = "phone";
    private final String PHONE_COUNTRY_CODE = "countryCode";
    private final String PHONE_CODE_AREA = "areaCode";
    private final String PHONE_NUMBER = "number";

    public CardHolderParser() {
        this.jsonDocument = new JSONObject();
    }

    public String toResource(Holder holder) throws MoIPSDKException {
        return this.parse(holder).toString();
    }

    public JSONObject parse(Holder holder) throws MoIPSDKException {
        try {
            this.jsonCardHolder.put("phone", (Object)this.jsonPhone);
            this.jsonCardHolder.put("taxDocument", (Object)this.jsonDocument);
            this.jsonCardHolder.put("fullname", (Object)holder.getFullname());
            StringBuilder sb = new StringBuilder();
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            int month = cal.get(2);
            int day = cal.get(5);
            sb.append(year);
            sb.append("-");
            if (month < 10) {
                sb.append(0);
            }
            sb.append(month);
            sb.append("-");
            if (day < 10) {
                sb.append(0);
            }
            sb.append(day);
            this.jsonCardHolder.put("birthdate", (Object)sb.toString());
            return this.jsonCardHolder;
        }
        catch (JSONException jse) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error while building the json ");
            throw new MoIPSDKException(sb.toString(), jse);
        }
    }

    private String justNumber(String text) throws MoIPSDKException {
        String number = text.replace("-", "").replace(" ", "").replace("(", "").replace(")", "").replace(".", "").replace(",", "");
        if (number.matches("[0-9]+")) {
            return number;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Wrong format ");
        sb.append(text);
        throw new MoIPSDKException(sb.toString(), new NumberFormatException());
    }

    private Holder fromJSON(JSONObject jsonCardHolder) {
        return null;
    }
}

