/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.parser;

import br.com.moip.android.entities.order.CreditCard;
import br.com.moip.android.exception.MoIPSDKException;
import br.com.moip.android.helper.MoIPUtils;
import br.com.moip.android.parser.CardHolderParser;
import br.com.moip.android.type.CreditCardBrand;
import org.json.JSONException;
import org.json.JSONObject;

public class CreditCardParser {
    private JSONObject jsonHolder;
    private CardHolderParser cardHolderParser = new CardHolderParser();
    private JSONObject jsonCreditCard;
    private final String HOLDER = "holder";
    private final String EXPIRATION_MONTH = "expirationMonth";
    private final String EXPIRATION_YEAR = "expirationYear";
    private final String NUMBER = "number";
    private final String CVC = "cvc";
    private final String OWN_ID = "owdId";
    private final String ID = "id";
    private final String CUSTOMER_OWN_ID = "customerOwnId";
    private final String BRAND = "brand";
    private final String FIRST6 = "first6";
    private final String LAST4 = "last4";

    public CreditCardParser() {
        this.jsonHolder = new JSONObject();
        this.jsonCreditCard = new JSONObject();
    }

    public String toResource(CreditCard creditCard) throws MoIPSDKException {
        return this.parse(creditCard).toString();
    }

    public JSONObject parse(CreditCard creditCard) throws MoIPSDKException {
        try {
            this.jsonHolder = this.cardHolderParser.parse(creditCard.getHolder());
            this.jsonCreditCard.put("holder", (Object)this.jsonHolder);
            String number = MoIPUtils.justNumber(creditCard.getNumber());
            if (!MoIPUtils.isValidCreditCard(number)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Invalid credit card number - ");
                sb.append(number);
                throw new MoIPSDKException(sb.toString());
            }
            this.jsonCreditCard.put("number", (Object)number);
            String cvc = creditCard.getCvc();
            if (!MoIPUtils.isValidCVC(cvc)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Invalid cvv");
                throw new MoIPSDKException(sb.toString());
            }
            this.jsonCreditCard.put("cvc", (Object)cvc);
            Integer expirationMonth = creditCard.getExpirationMonth();
            if (!MoIPUtils.isValidMonth(expirationMonth)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Invalid month");
                throw new MoIPSDKException(sb.toString());
            }
            this.jsonCreditCard.put("expirationMonth", (Object)expirationMonth);
            Integer expirationYear = creditCard.getExpirationYear();
            this.jsonCreditCard.put("expirationYear", (Object)expirationYear);
            this.jsonCreditCard.put("owdId", (Object)creditCard.getOwnID());
        }
        catch (JSONException jse) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error while building the json ");
            throw new MoIPSDKException(sb.toString(), jse);
        }
        return this.jsonCreditCard;
    }

    public CreditCard fromJSON(JSONObject jsonCreditCard) throws JSONException {
        CreditCard creditCard = new CreditCard();
        creditCard.setBrand(CreditCardBrand.fromDescription(jsonCreditCard.getString("brand")));
        creditCard.setFirst6(jsonCreditCard.getString("first6"));
        creditCard.setLast4(jsonCreditCard.getString("last4"));
        return creditCard;
    }
}

