/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.parser;

import android.util.Log;
import br.com.moip.android.exception.MoipError;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MoipErrorParser {
    private final String CODE = "code";
    private final String PATH = "path";
    private final String DESCRIPTION = "description";

    public MoipError fromJSON(JSONObject jsonObject) throws JSONException {
        MoipError moipError = new MoipError();
        moipError.setCode(jsonObject.getString("code"));
        moipError.setPath(jsonObject.getString("path"));
        moipError.setDescription(jsonObject.getString("description"));
        return moipError;
    }

    public List<MoipError> fromJSONArray(JSONArray jsonArray) throws JSONException {
        ArrayList<MoipError> moipErrorList = new ArrayList<MoipError>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            MoipError moipError = this.fromJSON(jsonArray.getJSONObject(i));
            moipErrorList.add(moipError);
        }
        return moipErrorList;
    }

    public List<MoipError> fromString(String errors) {
        JSONObject jsonObject = null;
        ArrayList<MoipError> moipErrorList = new ArrayList<MoipError>();
        MoipError moipError = null;
        try {
            jsonObject = new JSONObject(errors);
            return this.fromJSONArray(jsonObject.getJSONArray("errors"));
        }
        catch (JSONException e) {
            moipError = new MoipError();
            try {
                jsonObject = new JSONObject(errors).getJSONArray("errors").getJSONObject(0);
                moipError.setCode(jsonObject.getString("code"));
                moipError.setDescription(jsonObject.getString("description"));
                Log.i((String)"MoipError", (String)moipError.toString());
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
            Log.i((String)"Errors", (String)errors);
            moipErrorList.add(moipError);
            return moipErrorList;
        }
    }
}

