/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.parser;

import br.com.moip.android.entities.order.SimplePayment;
import br.com.moip.android.exception.MoIPSDKException;
import br.com.moip.android.parser.CreditCardParser;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentParser {
    private JSONObject jsonCreditCard;
    private CreditCardParser creditCardParser = new CreditCardParser();
    private JSONObject jsonParent;
    private JSONObject jsonPayment;
    private final String METHOD_TYPE = "CREDIT_CARD";
    private final String INSTALLMENT_COUNT = "installmentCount";
    private final String METHOD = "method";
    private final String CREDIT_CARD = "creditCard";
    private final String FUNDING_INSTRUMENT = "fundingInstrument";

    public PaymentParser() {
        this.jsonCreditCard = new JSONObject();
        this.jsonPayment = new JSONObject();
        this.jsonParent = new JSONObject();
    }

    public String toResource(SimplePayment simplePayment) throws MoIPSDKException {
        return this.parse(simplePayment).toString();
    }

    public JSONObject parse(SimplePayment simplePayment) throws MoIPSDKException {
        try {
            this.jsonCreditCard = this.creditCardParser.parse(simplePayment.getCreditCard());
            this.jsonPayment.put("creditCard", (Object)this.jsonCreditCard);
            this.jsonPayment.put("method", (Object)"CREDIT_CARD");
            this.jsonParent.put("installmentCount", (Object)simplePayment.getInstallmentCount());
            this.jsonParent.put("fundingInstrument", (Object)this.jsonPayment);
        }
        catch (JSONException jse) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error while building the json ");
            throw new MoIPSDKException(sb.toString(), jse);
        }
        return this.jsonParent;
    }
}

