/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.parser;

import br.com.moip.android.entities.order.Amount;
import br.com.moip.android.entities.order.Event;
import br.com.moip.android.entities.order.Fee;
import br.com.moip.android.entities.order.FundingInstrument;
import br.com.moip.android.entities.order.Payment;
import br.com.moip.android.parser.AmountParser;
import br.com.moip.android.parser.EventParser;
import br.com.moip.android.parser.FeeParser;
import br.com.moip.android.parser.FundingInstrumentParser;
import java.text.ParseException;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentTransactionParser {
    private final String ID = "id";
    private final String STATUS = "status";
    private final String INSTALLMENT_COUNT = "installmentCount";
    private final String CREATED_AT = "createdAt";
    private final String UPDATED_AT = "updatedAt";
    private final String AMOUNT = "amount";
    private AmountParser amountParser = new AmountParser();
    private final String FUNDING_INSTRUMENT = "fundingInstrument";
    private FundingInstrumentParser fundingInstrumentParser = new FundingInstrumentParser();
    private final String FEES = "fees";
    private FeeParser feeParser = new FeeParser();
    private final String EVENTS = "events";
    private EventParser eventParser = new EventParser();

    public Payment fromJSON(JSONObject jsonPaymentTransaction) throws JSONException, ParseException {
        Payment payment = new Payment();
        Amount amount = this.amountParser.fromJSON(jsonPaymentTransaction.getJSONObject("amount"));
        FundingInstrument fundingInstrument = this.fundingInstrumentParser.fromJSON(jsonPaymentTransaction.getJSONObject("fundingInstrument"));
        List<Fee> fees = this.feeParser.fromJSONArray(jsonPaymentTransaction.getJSONArray("fees"));
        List<Event> events = this.eventParser.fromJSONArray(jsonPaymentTransaction.getJSONArray("events"));
        payment.setMoipOrderID(jsonPaymentTransaction.getString("id"));
        payment.setInstallmentCount(jsonPaymentTransaction.getInt("installmentCount"));
        payment.setAmount(amount);
        payment.setFundingInstrument(fundingInstrument);
        payment.setFees(fees);
        payment.setEvents(events);
        return payment;
    }
}

