/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.security;

import android.util.Base64;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.jce.provider.BouncyCastleProvider;

public class KeyManager {
    private static KeyManager instance;
    private static PublicKey usablePublicKey;
    private static String sPublicKey;
    private static Cipher cipher;

    public static KeyManager getInstance() throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException {
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static KeyManager newInstance(String publicKey) throws NoSuchPaddingException, NoSuchAlgorithmException, IOException, InvalidKeySpecException, NoSuchProviderException {
        try {
            cipher = Cipher.getInstance("RSA/None/PKCS1Padding", "SC");
        }
        catch (SecurityException se) {
            Log.i((String)"Moip SDK", (String)"No SC provider, running test profile");
            cipher = Cipher.getInstance("RSA");
        }
        if (instance == null) {
            instance = new KeyManager(publicKey);
            return instance;
        }
        return KeyManager.getInstance();
    }

    public String encrypt(String data) throws IOException, InvalidCipherTextException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        cipher.init(1, usablePublicKey);
        byte[] cipherText = cipher.doFinal(data.getBytes());
        return Base64.encodeToString((byte[])cipherText, (int)0);
    }

    private KeyManager(String PEMString) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        sPublicKey = PEMString;
        BufferedReader pemReader = null;
        pemReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(PEMString.getBytes("UTF-8"))));
        StringBuffer content = new StringBuffer();
        String line = null;
        while ((line = pemReader.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY-----") == -1) continue;
            while ((line = pemReader.readLine()) != null && line.indexOf("-----END PUBLIC KEY") == -1) {
                content.append(line.trim());
            }
            break block0;
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        usablePublicKey = keyFactory.generatePublic(new X509EncodedKeySpec(Base64.decode((String)content.toString(), (int)0)));
    }

    static {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
    }
}

