/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.tasks;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import br.com.moip.android.components.views.MoipOAuthLoginActivity;
import br.com.moip.android.helper.MoipSharedPreferences;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginOauth
extends AsyncTask<Void, Void, Void> {
    private Context context;
    private ProgressDialog dialog;
    private AlertDialog.Builder errorDialog;
    private String email;
    private String password;
    private MoipOAuthLoginActivity moipOAuthLoginActivity;

    public void setUpProgressDialog(Context context) {
        this.context = context;
        this.dialog = new ProgressDialog(context);
        this.dialog.setMessage((CharSequence)"Conectando ao Moip");
        this.errorDialog = new AlertDialog.Builder(context);
        this.errorDialog.setMessage((CharSequence)"O seu login ou senha n\u00e3o conferem").setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                LoginOauth.this.moipOAuthLoginActivity.failure();
            }
        });
    }

    public void setUpAccount(String email, String password) {
        this.email = email;
        this.password = password;
    }

    protected void onPreExecute() {
        this.dialog.show();
    }

    protected Void doInBackground(Void ... voids) {
        this.login(this.email, this.password);
        return null;
    }

    protected void onPostExecute(Void token) {
        this.dialog.cancel();
        if (MoipSharedPreferences.getInstance().isLogged()) {
            this.moipOAuthLoginActivity.success();
        } else {
            this.errorDialog.create().show();
        }
    }

    protected void onCancelled() {
        this.dialog.cancel();
        this.errorDialog.create().show();
    }

    public String login(String email, String password) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(MoipSharedPreferences.getInstance().getEnvironment() + "oauth/accesstoken");
        String responseBody = "";
        HttpResponse response = null;
        try {
            httppost.setHeader("Content-Type", "application/json");
            JSONObject obj = new JSONObject();
            obj.put("appId", (Object)MoipSharedPreferences.getInstance().getAppId());
            obj.put("appSecret", (Object)MoipSharedPreferences.getInstance().getAppSecret());
            obj.put("grantType", (Object)"password");
            obj.put("username", (Object)email);
            obj.put("password", (Object)password);
            httppost.setEntity((HttpEntity)new StringEntity(obj.toString(), "UTF-8"));
            response = httpclient.execute((HttpUriRequest)httppost);
            responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                MoipSharedPreferences.getInstance().saveOauth(new JSONObject(responseBody).getString("accessToken"));
                MoipSharedPreferences.getInstance().saveExternalId(new JSONObject(responseBody).getString("moipAccountId"));
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return responseBody;
    }

    public void setLoginActivity(MoipOAuthLoginActivity moipOAuthLoginActivity) {
        this.moipOAuthLoginActivity = moipOAuthLoginActivity;
    }
}

