/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.tasks;

import android.os.AsyncTask;
import br.com.moip.API;
import br.com.moip.Client;
import br.com.moip.android.callback.MoipCallback;
import br.com.moip.android.tasks.AsyncTaskResult;
import br.com.moip.authentication.Authentication;

public abstract class MoipAsyncTask<I, O>
extends AsyncTask<I, Void, AsyncTaskResult<O>> {
    private final MoipCallback moipCallback;
    private final API api;

    public MoipAsyncTask(String endpoint, Authentication authentication, MoipCallback moipCallback) {
        this.moipCallback = moipCallback;
        Client client = new Client(endpoint, authentication);
        this.api = new API(client);
    }

    protected AsyncTaskResult<O> doInBackground(I ... ts) {
        try {
            O result = ts.length > 0 ? this.process(ts[0]) : this.process(null);
            return new AsyncTaskResult<O>(result);
        }
        catch (Exception e) {
            return new AsyncTaskResult(e);
        }
    }

    protected abstract O process(I var1);

    protected void onPostExecute(AsyncTaskResult<O> asyncTaskResult) {
        if (asyncTaskResult.isValidationException()) {
            this.moipCallback.validationError(asyncTaskResult.getValidationErrors());
        } else if (asyncTaskResult.isUnexpectedException()) {
            this.moipCallback.unexpectedError(asyncTaskResult.getException());
        } else {
            this.moipCallback.success(asyncTaskResult.getResult());
        }
    }

    public API getAPI() {
        return this.api;
    }
}

