/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.resource;

import br.com.moip.MoipHttp;
import br.com.moip.resource.MoipResource;
import br.com.moip.resource.structure.Address;
import br.com.moip.resource.structure.FundingInstrument;
import br.com.moip.resource.structure.Phone;
import br.com.moip.resource.structure.TaxDocument;
import com.google.gson.Gson;

public class Customer
extends MoipResource {
    private String id;
    private String ownId;
    private String fullname;
    private String email;
    private Phone phone = new Phone();
    private String birthDate;
    private TaxDocument taxDocument;
    private FundingInstrument fundingInstrument;
    private Address shippingAddress;

    public Customer create() {
        Gson gson = new Gson();
        MoipHttp moipHttp = this.moip.getMoipHttp();
        String json = moipHttp.sendRequest("/v2/customers", "POST", gson.toJson((Object)this));
        Customer customer = (Customer)gson.fromJson(json, Customer.class);
        customer.setMoip(this.moip);
        return customer;
    }

    public Customer get(String id) {
        Gson gson = new Gson();
        MoipHttp moipHttp = this.moip.getMoipHttp();
        String json = moipHttp.sendRequest("/v2/customers/" + id, "GET");
        Customer customer = (Customer)gson.fromJson(json, Customer.class);
        customer.setMoip(this.moip);
        return customer;
    }

    public String getId() {
        return this.id;
    }

    public String getOwnId() {
        return this.ownId;
    }

    public Customer setOwnId(String ownId) {
        this.ownId = ownId;
        return this;
    }

    public String getFullname() {
        return this.fullname;
    }

    public Customer setFullname(String fullname) {
        this.fullname = fullname;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Customer setEmail(String email) {
        this.email = email;
        return this;
    }

    public Phone getPhone() {
        return this.phone;
    }

    public Customer setPhone(String areaCode, String number) {
        return this.setPhone(areaCode, number, "55");
    }

    public Customer setPhone(String areaCode, String number, String countryCode) {
        this.phone = new Phone();
        this.phone.setAreaCode(areaCode);
        this.phone.setNumber(number);
        this.phone.setCountryCode(countryCode);
        return this;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public Customer setBirthDate(String birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    public TaxDocument getTaxDocument() {
        return this.taxDocument;
    }

    public Customer setTaxDocument(String number) {
        return this.setTaxDocument(number, "CPF");
    }

    public Customer setTaxDocument(String number, String type) {
        this.taxDocument = new TaxDocument();
        this.taxDocument.setType(type);
        this.taxDocument.setNumber(number);
        return this;
    }

    public Customer setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }
}

