/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.resource;

import br.com.moip.MoipHttp;
import br.com.moip.resource.Customer;
import br.com.moip.resource.MoipResource;
import br.com.moip.resource.Order;
import br.com.moip.resource.Payment;
import br.com.moip.resource.structure.Amount;
import br.com.moip.resource.structure.BankAccount;
import br.com.moip.resource.structure.FundingInstrument;
import br.com.moip.resource.structure.Holder;
import com.google.gson.Gson;

public class Refund
extends MoipResource {
    private String id;
    private String status;
    private Amount amount;
    private String type;
    private FundingInstrument refundingInstrument;
    private String method;
    private transient Order order;
    private transient Payment payment;

    public Refund execute() {
        if (this.order != null || this.payment != null) {
            Gson gson = new Gson();
            String path = this.order == null ? "/v2/payments/" + this.payment.getId() + "/refunds" : "/v2/orders/" + this.order.getId() + "/refunds";
            MoipHttp moipHttp = this.moip.getMoipHttp();
            String json = moipHttp.sendRequest(path, "POST", gson.toJson((Object)this));
            Refund refund = (Refund)gson.fromJson(json, Refund.class);
            refund.setMoip(this.moip);
            return refund;
        }
        return this;
    }

    public Refund get(String id) {
        Gson gson = new Gson();
        MoipHttp moipHttp = this.moip.getMoipHttp();
        String json = moipHttp.sendRequest("/v2/refunds/" + id, "GET");
        Refund refund = (Refund)gson.fromJson(json, Refund.class);
        refund.setMoip(this.moip);
        return refund;
    }

    public String getId() {
        return this.id;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public String getMethod() {
        return this.method;
    }

    private Refund bankAccount(String type, String bankType, String bankNumber, String agencyNumber, String agencyCheckNumber, String accountNumber, String accountCheckNumber, Customer customer) {
        Holder holder = new Holder();
        holder.setFullname(customer.getFullname());
        holder.setTaxDocument(customer.getTaxDocument());
        this.type = type;
        this.method = "BANK_ACCOUNT";
        this.refundingInstrument = new FundingInstrument();
        BankAccount bankAccount = this.refundingInstrument.getBankAccount();
        bankAccount.setType(bankType);
        bankAccount.setBankNumber(bankNumber);
        bankAccount.setAgencyNumber(agencyNumber);
        bankAccount.setAgencyCheckNumber(agencyCheckNumber);
        bankAccount.setAccountNumber(accountNumber);
        bankAccount.setAccountCheckNumber(accountCheckNumber);
        bankAccount.setHolder(holder);
        return this;
    }

    public Refund bankAccountFull(String type, String bankNumber, String agencyNumber, String agencyCheckNumber, String accountNumber, String accountCheckNumber, Customer customer) {
        return this.bankAccount("FULL", type, bankNumber, agencyNumber, agencyCheckNumber, accountNumber, accountCheckNumber, customer);
    }

    public Refund bankAccountPartial(Integer amount, String type, String bankNumber, String agencyNumber, String agencyCheckNumber, String accountNumber, String accountCheckNumber, Customer customer) {
        this.amount = new Amount();
        this.amount.setTotal(amount);
        return this.bankAccount("PARTIAL", type, bankNumber, agencyNumber, agencyCheckNumber, accountNumber, accountCheckNumber, customer);
    }

    private Refund creditCard(String type) {
        this.method = "CREDIT_CARD";
        this.type = type;
        return this;
    }

    public Refund creditCardFull() {
        return this.creditCard("FULL");
    }

    public Refund creditCardPartial(Integer amount) {
        this.amount = new Amount();
        this.amount.setTotal(amount);
        return this.creditCard("PARTIAL");
    }

    public Refund setOrder(Order order) {
        this.order = order;
        return this;
    }

    public Refund setPayment(Payment payment) {
        this.payment = payment;
        return this;
    }
}

