/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.api;

import br.com.moip.Client;
import br.com.moip.exception.ValidationException;
import br.com.moip.request.BankAccountRequest;
import br.com.moip.resource.BankAccount;
import java.util.Arrays;
import java.util.List;

public class BankAccountsAPI {
    private final Client client;

    public BankAccountsAPI(Client client) {
        this.client = client;
    }

    public BankAccount create(String moipAccount, BankAccountRequest bankAccountRequest) {
        return this.client.post(String.format("/v2/accounts/%s/bankaccounts", moipAccount), bankAccountRequest, BankAccount.class);
    }

    public BankAccount get(String id) {
        return this.client.get(String.format("/v2/bankaccounts/%s", id), BankAccount.class);
    }

    public List<BankAccount> getList(String moipAccount) {
        BankAccount[] bankAccounts = this.client.get(String.format("/v2/accounts/%s/bankaccounts", moipAccount), BankAccount[].class);
        return Arrays.asList(bankAccounts);
    }

    public BankAccount update(String id, BankAccountRequest bankAccountRequest) {
        return this.client.put(String.format("/v2/bankaccounts/%s", id), bankAccountRequest, BankAccount.class);
    }

    public Boolean delete(String id) {
        try {
            this.client.delete(String.format("/v2/bankaccounts/%s", id), BankAccount.class);
            return true;
        }
        catch (ValidationException e) {
            if (e.getResponseCode() != 404) {
                throw new ValidationException(e.getResponseCode(), e.getResponseStatus(), e.getError());
            }
            return false;
        }
    }
}

