/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.api;

import br.com.moip.Client;
import br.com.moip.api.filter.Pagination;
import br.com.moip.request.InvoiceRequest;
import br.com.moip.resource.Invoice;
import br.com.moip.response.InvoiceListResponse;

public class InvoiceAPI {
    private final Client client;

    public InvoiceAPI(Client client) {
        this.client = client;
    }

    public Invoice create(InvoiceRequest invoice) {
        return this.client.post("/v2/invoices", invoice, Invoice.class);
    }

    public Invoice get(String id) {
        return this.client.get("/v2/invoices/" + id, Invoice.class);
    }

    public InvoiceListResponse list() {
        return this.client.get("/v2/invoices", InvoiceListResponse.class);
    }

    public InvoiceListResponse list(Pagination pagination) {
        if (pagination.getLimit() == 0) {
            return this.client.get("/v2/invoices", InvoiceListResponse.class);
        }
        if (pagination.getOffset() <= 0) {
            return this.client.get("/v2/invoices?limit=" + pagination.getLimit(), InvoiceListResponse.class);
        }
        return this.client.get("/v2/invoices?limit=" + pagination.getLimit() + "&offset=" + pagination.getOffset(), InvoiceListResponse.class);
    }
}

