/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.api;

import br.com.moip.Client;
import br.com.moip.api.Endpoint;
import br.com.moip.request.RefundRequest;
import br.com.moip.resource.Refund;
import br.com.moip.response.RefundsListResponse;

public class RefundAPI
extends Endpoint {
    private final Client client;

    public RefundAPI(Client client) {
        this.client = client;
    }

    public Refund order(RefundRequest refundRequest) {
        return this.client.post(this.buildRefundEndpointForOrder(refundRequest), refundRequest, Refund.class);
    }

    public Refund payment(RefundRequest refundRequest) {
        return this.client.post(this.buildRefundEndpointForPayment(refundRequest), refundRequest, Refund.class);
    }

    public Refund get(String refundId) {
        return this.client.get(this.buildRefundEndpointForGet(refundId), Refund.class);
    }

    public RefundsListResponse list(String id) {
        if (id.startsWith("PAY-")) {
            return this.client.get(this.buildRefundEndpointForListByPayment(id), RefundsListResponse.class);
        }
        return this.client.get(this.buildRefundEndpointForListByOrder(id), RefundsListResponse.class);
    }
}

