/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.api;

import br.com.moip.Client;
import br.com.moip.api.filter.Pagination;
import br.com.moip.request.TransferRequest;
import br.com.moip.resource.Transfer;
import br.com.moip.response.TransferListResponse;

public class TransferApi {
    private final Client client;
    private static final String TRANSFER_URL = "/v2/transfers";

    public TransferApi(Client client) {
        this.client = client;
    }

    public Transfer create(TransferRequest transfer) {
        return this.client.post(TRANSFER_URL, transfer, Transfer.class);
    }

    public Transfer reverse(String id) {
        return this.client.post("/v2/transfers/" + id + "/reverse", Transfer.class);
    }

    public Transfer get(String id) {
        return this.client.get("/v2/transfers/" + id, Transfer.class);
    }

    public TransferListResponse list() {
        return this.client.get(TRANSFER_URL, TransferListResponse.class);
    }

    public TransferListResponse list(Pagination pagination) {
        if (pagination.getLimit() == 0) {
            return this.client.get(TRANSFER_URL, TransferListResponse.class);
        }
        if (pagination.getOffset() <= 0) {
            return this.client.get("/v2/transfers?limit=" + pagination.getLimit(), TransferListResponse.class);
        }
        return this.client.get("/v2/transfers?limit=" + pagination.getLimit() + "&offset=" + pagination.getOffset(), TransferListResponse.class);
    }
}

