/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.request;

import br.com.moip.request.CheckoutPreferencesRequest;
import br.com.moip.request.CustomerRequest;
import br.com.moip.request.OrderAmountRequest;
import br.com.moip.request.ReceiverRequest;
import java.util.ArrayList;
import java.util.List;

public class OrderRequest {
    private String ownId;
    private OrderAmountRequest amount;
    private final List<ItemRequest> items = new ArrayList<ItemRequest>();
    private CustomerRequest customer;
    private final List<ReceiverRequest> receivers = new ArrayList<ReceiverRequest>();
    private CheckoutPreferencesRequest checkoutPreferences;

    public String getOwnId() {
        return this.ownId;
    }

    public OrderRequest ownId(String ownId) {
        this.ownId = ownId;
        return this;
    }

    public OrderAmountRequest getAmount() {
        return this.amount;
    }

    public OrderRequest amount(OrderAmountRequest amount) {
        this.amount = amount;
        return this;
    }

    public List<ItemRequest> getItems() {
        return this.items;
    }

    public OrderRequest addItem(String product, Integer quantity, String detail, Integer price) {
        this.items.add(new ItemRequest(product, quantity, detail, price));
        return this;
    }

    public List<ReceiverRequest> getReceivers() {
        return this.receivers;
    }

    public OrderRequest addReceiver(ReceiverRequest receiverRequest) {
        this.receivers.add(receiverRequest);
        return this;
    }

    public CustomerRequest getCustomer() {
        return this.customer;
    }

    public OrderRequest customer(CustomerRequest customer) {
        this.customer = customer;
        return this;
    }

    public CheckoutPreferencesRequest getCheckoutPreferences() {
        return this.checkoutPreferences;
    }

    public OrderRequest checkoutPreferences(CheckoutPreferencesRequest checkoutPreferences) {
        this.checkoutPreferences = checkoutPreferences;
        return this;
    }

    public String toString() {
        return "OrderRequest{" + "ownId='" + this.ownId + '\'' + ", items=" + this.items + ", customer=" + this.customer + ", checkoutPreferences=" + this.checkoutPreferences + '}';
    }

    public static final class ItemRequest {
        private final String product;
        private final Integer quantity;
        private final String detail;
        private final Integer price;

        public ItemRequest(String product, Integer quantity, String detail, Integer price) {
            this.product = product;
            this.quantity = quantity;
            this.detail = detail;
            this.price = price;
        }

        public String getProduct() {
            return this.product;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public String getDetail() {
            return this.detail;
        }

        public Integer getPrice() {
            return this.price;
        }

        public String toString() {
            return "Item{" + "product='" + this.product + '\'' + ", quantity=" + this.quantity + ", detail='" + this.detail + '\'' + ", price=" + this.price + '}';
        }
    }
}

