/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.request;

import br.com.moip.request.AmountRequest;
import br.com.moip.request.MoipAccountRequest;
import br.com.moip.request.ReceiverTypeRequest;

public class ReceiverRequest {
    private ReceiverTypeRequest type;
    private MoipAccountRequest moipAccount;
    private AmountRequest amount;
    private boolean feePayor;

    public ReceiverRequest primary(String moipAccount, AmountRequest amountRequest) {
        this.defaultAttributes(ReceiverTypeRequest.PRIMARY, moipAccount, amountRequest, true);
        return this;
    }

    public ReceiverRequest primary(String moipAccount, AmountRequest amountRequest, boolean feePayor) {
        this.defaultAttributes(ReceiverTypeRequest.PRIMARY, moipAccount, amountRequest, feePayor);
        return this;
    }

    public ReceiverRequest secondary(String moipAccount, AmountRequest amountRequest) {
        this.defaultAttributes(ReceiverTypeRequest.SECONDARY, moipAccount, amountRequest, false);
        return this;
    }

    public ReceiverRequest secondary(String moipAccount, AmountRequest amountRequest, boolean feePayor) {
        this.defaultAttributes(ReceiverTypeRequest.SECONDARY, moipAccount, amountRequest, feePayor);
        return this;
    }

    private void defaultAttributes(ReceiverTypeRequest receiverTypeRequest, String moipAccount, AmountRequest amountRequest, boolean feePayor) {
        this.type = receiverTypeRequest;
        this.moipAccount = new MoipAccountRequest(moipAccount);
        this.amount = amountRequest;
        this.feePayor = feePayor;
    }

    public ReceiverTypeRequest getType() {
        return this.type;
    }

    public MoipAccountRequest getMoipAccount() {
        return this.moipAccount;
    }

    public AmountRequest getAmount() {
        return this.amount;
    }

    public boolean getFeePayor() {
        return this.feePayor;
    }
}

