/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.resource;

import br.com.moip.resource.Address;
import br.com.moip.resource.Amount;
import br.com.moip.resource.CheckoutPreferences;
import br.com.moip.resource.Customer;
import br.com.moip.resource.Entry;
import br.com.moip.resource.Escrow;
import br.com.moip.resource.Event;
import br.com.moip.resource.OrderStatus;
import br.com.moip.resource.Payment;
import br.com.moip.resource.Receiver;
import br.com.moip.resource.Refund;
import br.com.moip.resource.links.OrderLinks;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Order {
    private String id;
    private String ownId;
    private OrderStatus status;
    private String platform;
    private Date createdAt;
    private Date updatedAt;
    private Amount amount;
    private final List<Item> items;
    private final List<Address> addresses = new ArrayList<Address>();
    private Customer customer;
    private final List<Payment> payments = new ArrayList<Payment>();
    private final List<Escrow> escrows = new ArrayList<Escrow>();
    private final List<Refund> refunds = new ArrayList<Refund>();
    private final List<Entry> entries = new ArrayList<Entry>();
    private final List<Event> events = new ArrayList<Event>();
    private final List<Receiver> receivers = new ArrayList<Receiver>();
    private CheckoutPreferences checkoutPreferences;
    private OrderLinks _links;

    public Order() {
        this.items = new ArrayList<Item>();
    }

    protected Order(Order order) {
        this.id = order.getId();
        this.amount = order.getAmount();
        this.ownId = order.getOwnId();
        this.customer = order.getCustomer();
        this.items = order.getItems();
    }

    public String getId() {
        return this.id;
    }

    public String getOwnId() {
        return this.ownId;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public List<Payment> getPayments() {
        return this.payments;
    }

    public List<Escrow> getEscrows() {
        return this.escrows;
    }

    public List<Refund> getRefunds() {
        return this.refunds;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<Receiver> getReceivers() {
        return this.receivers;
    }

    public CheckoutPreferences getCheckoutPreferences() {
        return this.checkoutPreferences;
    }

    public OrderLinks getLinks() {
        return this._links;
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    public void setCheckoutPreferences(CheckoutPreferences checkoutPreferences) {
        this.checkoutPreferences = checkoutPreferences;
    }

    public void setLinks(OrderLinks _links) {
        this._links = _links;
    }

    public String toString() {
        return "Order{" + "id='" + this.id + '\'' + ", ownId='" + this.ownId + '\'' + ", status='" + (Object)((Object)this.status) + '\'' + ", platform='" + this.platform + '\'' + ", createdAt='" + this.createdAt + '\'' + ", updatedAt='" + this.updatedAt + '\'' + ", amount=" + this.amount + ", items=" + this.items + ", addresses=" + this.addresses + ", customer=" + this.customer + ", payments=" + this.payments + ", escrows=" + this.escrows + ", refunds=" + this.refunds + ", entries=" + this.entries + ", events=" + this.events + ", receivers=" + this.receivers + ", checkoutPreferences=" + this.checkoutPreferences + ", _links=" + this._links + '}';
    }

    public static final class Item {
        private String product;
        private Integer quantity;
        private String detail;
        private Integer price;
        private String category;

        public String getProduct() {
            return this.product;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public String getDetail() {
            return this.detail;
        }

        public Integer getPrice() {
            return this.price;
        }

        public String getCategory() {
            return this.category;
        }

        public String toString() {
            return "Item{" + "product='" + this.product + '\'' + ", quantity=" + this.quantity + ", detail='" + this.detail + '\'' + ", price=" + this.price + ", category='" + this.category + '\'' + '}';
        }
    }
}

