package buzz.getcoco.media;

/**
 * The response class for corresponding to a {@link Command} class.
 *
 * @param <T> The capture of CommandId
 */
public class CommandResponse<T extends CommandIdInterface> {

  private transient Command.State status;
  private transient T commandId;
  private transient String errorMessage;

  protected CommandResponse(T commandId) {
    this.commandId = commandId;
  }

  void setStatus(Command.State status) {
    this.status = status;
  }

  public Command.State getStatus() {
    return status;
  }

  void setCommandId(T commandId) {
    this.commandId = commandId;
  }

  public T getCommandId() {
    return commandId;
  }

  void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public String getErrorMessage() {
    return errorMessage;
  }

  @Override
  public String toString() {
    return "CommandResponse{"
           + "status=" + status
           + ", commandId=" + commandId
           + ", errorMessage='" + errorMessage + '\''
           + '}';
  }
}
