package buzz.getcoco.media;

import java.nio.ByteBuffer;

/**
 * An interface whose implementation decided how cbs are processed.
 *
 * @see DefaultNativeCallbacksHandler
 * @see NativeCallbacks
 */
public interface NativeCallbacksInterface {

  void authCallback(String authEndPoint, String tokenEndPoint);

  void httpCommandStatusCallback(String response, Object context);

  void networkCommandStatusCallback(String response, Object context);

  void connectStatusCallback(int status, Object connectContext);

  void channelJoinStatusCallback(int channelId, int status, Object joinContext);

  void channelStreamInfoCallback(int channelId, long streamId, long sourceNodeId,
                                 int status, String sdp, Object joinContext);

  void streamStatusChangedCallback(int channelId, long streamHandle, long sourceNodeId,
                                   int streamStatus, Object streamContext);

  void streamDataReceivedCallback(ByteBuffer data, Object streamContext);

  void messageReceivedCallback(String message, long sourceNodeId, Object connectContext);

  void contentInfoReceivedCallback(String message, int contentTime,
                                   long sourceNodeId, Object connectContext);

  void nodeConnectionStatusCallback(long nodeId, boolean isOnline,
                                    Object connectContext);
}
