package buzz.getcoco.media;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

/**
 * A data class for creating {@link RxStream}.
 */
public final class RxStreamInfo {

  private static final Set<RxStreamInfo> ACTIVE_STREAM_INFO = new HashSet<>();

  private final String sdp;
  private final String networkId;
  private final int channelId;
  private final long streamId;
  private final long sourceNodeId;

  RxStreamInfo(String sdp, String networkId, int channelId, long streamId, long sourceNodeId) {
    this.sdp = sdp;
    this.networkId = networkId;
    this.channelId = channelId;
    this.streamId = streamId;
    this.sourceNodeId = sourceNodeId;
  }

  public String getSdp() {
    return sdp;
  }

  public String getNetworkId() {
    return networkId;
  }

  public int getChannelId() {
    return channelId;
  }

  public long getStreamId() {
    return streamId;
  }

  public long getSourceNodeId() {
    return sourceNodeId;
  }

  static void activateStream(RxStreamInfo streamInfo) {
    ACTIVE_STREAM_INFO.add(streamInfo);
  }

  static void deactivateStream(RxStreamInfo streamInfo) {
    ACTIVE_STREAM_INFO.remove(streamInfo);
  }

  static boolean isDestroyed(RxStreamInfo streamInfo) {
    return !ACTIVE_STREAM_INFO.contains(streamInfo);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (!(o instanceof RxStreamInfo)) {
      return false;
    }

    RxStreamInfo that = (RxStreamInfo) o;

    return channelId == that.channelId
           && streamId == that.streamId
           && Objects.equals(networkId, that.networkId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(networkId, channelId, streamId);
  }

  @Override
  public String toString() {
    return "RxStreamInfo{"
           + "sdp='" + sdp + '\''
           + ", networkId='" + networkId + '\''
           + ", channelId=" + channelId
           + ", streamId=" + streamId
           + ", sourceNodeId=" + sourceNodeId
           + '}';
  }
}
