package buzz.getcoco.media;

import com.google.gson.annotations.SerializedName;

/**
 * The class representing a user.
 */
public class User {

  /**
   * An enum indicating the join status of the user for a given network.
   */
  public enum Status {
    NOT_JOINED,
    JOINED,
    PENDING
  }

  @SerializedName(Constants.USERNAME)
  private final String username;

  @SerializedName(Constants.USER_ID)
  private final String userId;

  @SerializedName(Constants.NAME)
  private final String name;

  @SerializedName(Constants.IMAGE_URL)
  private final String imageUrl;

  @SerializedName(Constants.STATUS)
  private final Status joinStatus;

  @SerializedName(Constants.EXTERNAL_USER_ID)
  private final String externalUserId;

  /**
   * constructor for this class.
   *
   * @param username       The username (email) of the user
   * @param userId         The unique id of the user
   * @param name           The name of the user
   * @param imageUrl       The profile image url of the user
   * @param joinStatus     The enum indicating the join status of the user
   * @param externalUserId The userId used by 3rd party login systems.
   */
  public User(String username, String userId, String name,
              String imageUrl, Status joinStatus, String externalUserId) {
    this.username = username;
    this.userId = userId;
    this.name = name;
    this.imageUrl = imageUrl;
    this.joinStatus = joinStatus;
    this.externalUserId = externalUserId;
  }

  public String getUsername() {
    return username;
  }

  public String getUserId() {
    return userId;
  }

  public String getName() {
    return name;
  }

  public String getImageUrl() {
    return imageUrl;
  }

  public Status getJoinStatus() {
    return joinStatus;
  }

  public String getExternalUserId() {
    return externalUserId;
  }

  @Override
  public String toString() {
    return "User{"
           + "username='" + username + '\''
           + ", userId='" + userId + '\''
           + ", name='" + name + '\''
           + ", imageUrl='" + imageUrl + '\''
           + ", joinStatus=" + joinStatus
           + ", externalUserId='" + externalUserId + '\''
           + '}';
  }
}
