/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jsondoclet;

import capital.scalable.restdocs.jsondoclet.DocletUtils;
import capital.scalable.restdocs.jsondoclet.FieldDocumentation;
import capital.scalable.restdocs.jsondoclet.MethodDocumentation;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import jdk.javadoc.doclet.DocletEnvironment;

public final class ClassDocumentation {
    private String comment = "";
    private final Map<String, FieldDocumentation> fields = new HashMap<String, FieldDocumentation>();
    private final Map<String, MethodDocumentation> methods = new HashMap<String, MethodDocumentation>();

    private ClassDocumentation() {
    }

    public static ClassDocumentation fromClassDoc(DocletEnvironment docEnv, Element element) {
        ClassDocumentation cd = new ClassDocumentation();
        cd.setComment(DocletUtils.cleanupDocComment(docEnv.getElementUtils().getDocComment(element)));
        element.getEnclosedElements().forEach(fieldOrMethod -> {
            if (fieldOrMethod.getKind().equals((Object)ElementKind.FIELD)) {
                cd.addField(docEnv, (Element)fieldOrMethod);
            } else if (fieldOrMethod.getKind().equals((Object)ElementKind.METHOD) || fieldOrMethod.getKind().equals((Object)ElementKind.CONSTRUCTOR)) {
                cd.addMethod(docEnv, (Element)fieldOrMethod);
            }
        });
        return cd;
    }

    private void setComment(String comment) {
        this.comment = comment;
    }

    private void addField(DocletEnvironment docEnv, Element element) {
        this.fields.put(element.getSimpleName().toString(), FieldDocumentation.fromFieldDoc(docEnv, element));
    }

    private void addMethod(DocletEnvironment docEnv, Element element) {
        this.methods.put(element.getSimpleName().toString(), MethodDocumentation.fromMethodDoc(docEnv, element));
    }
}

