/*
 * Decompiled with CFR 0.152.
 */
package cc.corly.springbean.trigger;

import cc.corly.springbean.trigger.SpringBeanTriggerService;
import cc.corly.springbean.trigger.TriggerService;
import com.alibaba.fastjson.JSON;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;

public class BeanHttpExpose
extends NanoHTTPD {
    private static final Logger log = LoggerFactory.getLogger(BeanHttpExpose.class);
    public static final String APPLICATION_JSON = "application/json";
    private TriggerService triggerService;

    private BeanHttpExpose(int port, TriggerService triggerService) throws IOException {
        super(port);
        this.start(5000, true);
        this.triggerService = triggerService;
    }

    public static final BeanHttpExpose build(BeanFactory beanFactory) throws IOException {
        return BeanHttpExpose.build(9009, beanFactory);
    }

    public static final BeanHttpExpose build(int port, BeanFactory beanFactory) throws IOException {
        SpringBeanTriggerService triggerService = new SpringBeanTriggerService(beanFactory);
        return BeanHttpExpose.build(port, triggerService);
    }

    public static final BeanHttpExpose build(int port, TriggerService triggerService) throws IOException {
        return new BeanHttpExpose(port, triggerService);
    }

    public NanoHTTPD.Response serve(String uri, NanoHTTPD.Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
        String respStr;
        if (method != NanoHTTPD.Method.POST) {
            return BeanHttpExpose.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, (String)"text/plain", (String)"only support POST method");
        }
        String[] splitUri = uri.split("/");
        if (splitUri.length < 3) {
            return BeanHttpExpose.newFixedLengthResponse((String)"\u4e0d\u652f\u6301\u53c2\u6570");
        }
        String beanName = splitUri[1];
        String methodName = splitUri[2];
        String postData = files.get("postData");
        NanoHTTPD.Response.Status status = NanoHTTPD.Response.Status.OK;
        try {
            List args = JSON.parseArray((String)postData, String.class);
            Object resp = this.triggerService.trigger(beanName, methodName, args);
            respStr = JSON.toJSONString((Object)resp);
        }
        catch (Exception e) {
            status = NanoHTTPD.Response.Status.INTERNAL_ERROR;
            respStr = e.getMessage();
            log.error("uri {} postData {}", new Object[]{uri, postData, e});
        }
        if (status == NanoHTTPD.Response.Status.OK) {
            BeanHttpExpose.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)APPLICATION_JSON, (String)respStr);
        }
        return BeanHttpExpose.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)respStr);
    }
}

