package cd.connect.features;

import cd.connect.openapi.support.ApiClient;
import cd.connect.openapi.support.ApiResponse;
import cd.connect.openapi.support.Pair;
import javax.ws.rs.BadRequestException;

import javax.ws.rs.core.GenericType;
import java.io.InputStream;

import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.*;

import cd.connect.features.FeatureState;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "cd.connect.openapi.Jersey2V3ApiGenerator", date = "2019-05-09T19:07:25.383+12:00[Pacific/Auckland]")

@Path("/features")
public interface FeatureService {

  /**
   * 
   * Gets a list of features and their states
   * @return List&lt;FeatureState&gt;
   */
  @GET
    @Produces({ "application/json" })
  public List<FeatureState> allFeatures();
  /**
   * 
   * Sets a list of features and their states in a single request
   * @param body  (required)
   * @return List&lt;FeatureState&gt;
   */
  @PUT
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
  public List<FeatureState> applyAll(List<FeatureState> body);
  /**
   * 
   * count number of features. Convenience function for UI.
   * @return Integer
   */
  @GET
    @Path("/count")
    @Produces({ "text/plain" })
  public Integer count();
  /**
   * 
   * Disables feature
   * @param name the feature name (required)
   * @return FeatureState
   */
  @PUT
    @Path("/disable/{name}")
    @Produces({ "application/json" })
  public FeatureState disableFeature( @PathParam("name") String name);
  /**
   * 
   * the features that are disabled. Convenience function for UI.
   * @return List&lt;String&gt;
   */
  @GET
    @Path("/disabled")
    @Produces({ "application/json" })
  public List<String> disabledFeatures();
  /**
   * 
   * Enables feature
   * @param name the feature name (required)
   * @return FeatureState
   */
  @PUT
    @Path("/enable/{name}")
    @Produces({ "application/json" })
  public FeatureState enableFeature( @PathParam("name") String name);
  /**
   * 
   * the features that are enabled. Convenience function for UI.
   * @return List&lt;String&gt;
   */
  @GET
    @Path("/enabled")
    @Produces({ "application/json" })
  public List<String> enabledFeatures();
  /**
   * 
   * Gets the details about the feature identified by the name
   * @param name the feature name (required)
   * @return FeatureState
   */
  @GET
    @Path("/feature/{name}")
    @Produces({ "application/json" })
  public FeatureState getFeature( @PathParam("name") String name);
  /**
   * 
   * Locks feature
   * @param name the feature name (required)
   * @return FeatureState
   */
  @PUT
    @Path("/lock/{name}")
    @Produces({ "application/json" })
  public FeatureState lockFeature( @PathParam("name") String name);
  /**
   * 
   * refresh feature states
   * @return String
   */
  @PUT
    @Path("/refresh")
    @Produces({ "application/json" })
  public String refresh();
  /**
   * 
   * Unlocks feature
   * @param name the feature name (required)
   * @return FeatureState
   */
  @PUT
    @Path("/unlock/{name}")
    @Produces({ "application/json" })
  public FeatureState unlockFeature( @PathParam("name") String name);
}
