/*
 * FeatureServiceApi
 * This describes the api for the feature toggle service
 *
 * OpenAPI spec version: 1.1.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package cd.connect.features.impl;

import cd.connect.openapi.support.ApiClient;
import cd.connect.openapi.support.ApiResponse;
import cd.connect.features.FeatureService;
import cd.connect.features.FeatureClientService;
import cd.connect.openapi.support.Pair;
import javax.ws.rs.BadRequestException;

import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.*;

import cd.connect.features.FeatureState;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "cd.connect.openapi.Jersey2V3ApiGenerator", date = "2019-05-09T19:07:25.383+12:00[Pacific/Auckland]")public class FeatureServiceImpl implements FeatureService, FeatureClientService {
  private ApiClient apiClient;

  public FeatureServiceImpl(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
  * 
  * Gets a list of features and their states
    * @return List&lt;FeatureState&gt;
  */
  public List<FeatureState> allFeatures() {
    return allFeaturesWithHttpInfo().getData();
  }

  /**
  * 
  * Gets a list of features and their states
    * @return List&lt;FeatureState&gt;
  */
  public List<FeatureState> allFeatures(Map<String, String> extraHeaders) {
    return allFeaturesWithHttpInfo(extraHeaders).getData();
  }

  /**
  * 
  * Gets a list of features and their states
    * @return ApiResponse&lt;List&lt;FeatureState&gt;&gt;
  */
  public ApiResponse<List<FeatureState>> allFeaturesWithHttpInfo() {
      return allFeaturesWithHttpInfo(null);

  }

    /**
   * 
   * Gets a list of features and their states
   * @return ApiResponse&lt;List&lt;FeatureState&gt;&gt;
   */
  public ApiResponse<List<FeatureState>> allFeaturesWithHttpInfo(Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // create path and map variables 
    String localVarPath = "";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<FeatureState>> localVarReturnType = new GenericType<List<FeatureState>>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * Sets a list of features and their states in a single request
    * @param body  (required)
    * @return List&lt;FeatureState&gt;
  */
  public List<FeatureState> applyAll(List<FeatureState> body) {
    return applyAllWithHttpInfo(body).getData();
  }

  /**
  * 
  * Sets a list of features and their states in a single request
    * @param body  (required)
    * @return List&lt;FeatureState&gt;
  */
  public List<FeatureState> applyAll(List<FeatureState> body, Map<String, String> extraHeaders) {
    return applyAllWithHttpInfo(body, extraHeaders).getData();
  }

  /**
  * 
  * Sets a list of features and their states in a single request
    * @param body  (required)
    * @return ApiResponse&lt;List&lt;FeatureState&gt;&gt;
  */
  public ApiResponse<List<FeatureState>> applyAllWithHttpInfo(List<FeatureState> body) {
      return applyAllWithHttpInfo(body, null);

  }

    /**
   * 
   * Sets a list of features and their states in a single request
   * @param body  (required)
   * @return ApiResponse&lt;List&lt;FeatureState&gt;&gt;
   */
  public ApiResponse<List<FeatureState>> applyAllWithHttpInfo(List<FeatureState> body, Map<String, String> extraHeaders) {
    Object localVarPostBody = body;
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new BadRequestException("Missing the required parameter 'body' when calling applyAll");
    }
    // create path and map variables 
    String localVarPath = "";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<FeatureState>> localVarReturnType = new GenericType<List<FeatureState>>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * count number of features. Convenience function for UI.
    * @return Integer
  */
  public Integer count() {
    return countWithHttpInfo().getData();
  }

  /**
  * 
  * count number of features. Convenience function for UI.
    * @return Integer
  */
  public Integer count(Map<String, String> extraHeaders) {
    return countWithHttpInfo(extraHeaders).getData();
  }

  /**
  * 
  * count number of features. Convenience function for UI.
    * @return ApiResponse&lt;Integer&gt;
  */
  public ApiResponse<Integer> countWithHttpInfo() {
      return countWithHttpInfo(null);

  }

    /**
   * 
   * count number of features. Convenience function for UI.
   * @return ApiResponse&lt;Integer&gt;
   */
  public ApiResponse<Integer> countWithHttpInfo(Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // create path and map variables /count
    String localVarPath = "/count";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "text/plain"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Integer> localVarReturnType = new GenericType<Integer>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * Disables feature
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState disableFeature( @PathParam("name") String name) {
    return disableFeatureWithHttpInfo(name).getData();
  }

  /**
  * 
  * Disables feature
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState disableFeature( @PathParam("name") String name, Map<String, String> extraHeaders) {
    return disableFeatureWithHttpInfo(name, extraHeaders).getData();
  }

  /**
  * 
  * Disables feature
    * @param name the feature name (required)
    * @return ApiResponse&lt;FeatureState&gt;
  */
  public ApiResponse<FeatureState> disableFeatureWithHttpInfo(String name) {
      return disableFeatureWithHttpInfo(name, null);

  }

    /**
   * 
   * Disables feature
   * @param name the feature name (required)
   * @return ApiResponse&lt;FeatureState&gt;
   */
  public ApiResponse<FeatureState> disableFeatureWithHttpInfo(String name, Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // verify the required parameter 'name' is set
    if (name == null) {
      throw new BadRequestException("Missing the required parameter 'name' when calling disableFeature");
    }
    // create path and map variables /disable/{name}
    String localVarPath = "/disable/{name}"
      .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<FeatureState> localVarReturnType = new GenericType<FeatureState>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * the features that are disabled. Convenience function for UI.
    * @return List&lt;String&gt;
  */
  public List<String> disabledFeatures() {
    return disabledFeaturesWithHttpInfo().getData();
  }

  /**
  * 
  * the features that are disabled. Convenience function for UI.
    * @return List&lt;String&gt;
  */
  public List<String> disabledFeatures(Map<String, String> extraHeaders) {
    return disabledFeaturesWithHttpInfo(extraHeaders).getData();
  }

  /**
  * 
  * the features that are disabled. Convenience function for UI.
    * @return ApiResponse&lt;List&lt;String&gt;&gt;
  */
  public ApiResponse<List<String>> disabledFeaturesWithHttpInfo() {
      return disabledFeaturesWithHttpInfo(null);

  }

    /**
   * 
   * the features that are disabled. Convenience function for UI.
   * @return ApiResponse&lt;List&lt;String&gt;&gt;
   */
  public ApiResponse<List<String>> disabledFeaturesWithHttpInfo(Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // create path and map variables /disabled
    String localVarPath = "/disabled";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<String>> localVarReturnType = new GenericType<List<String>>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * Enables feature
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState enableFeature( @PathParam("name") String name) {
    return enableFeatureWithHttpInfo(name).getData();
  }

  /**
  * 
  * Enables feature
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState enableFeature( @PathParam("name") String name, Map<String, String> extraHeaders) {
    return enableFeatureWithHttpInfo(name, extraHeaders).getData();
  }

  /**
  * 
  * Enables feature
    * @param name the feature name (required)
    * @return ApiResponse&lt;FeatureState&gt;
  */
  public ApiResponse<FeatureState> enableFeatureWithHttpInfo(String name) {
      return enableFeatureWithHttpInfo(name, null);

  }

    /**
   * 
   * Enables feature
   * @param name the feature name (required)
   * @return ApiResponse&lt;FeatureState&gt;
   */
  public ApiResponse<FeatureState> enableFeatureWithHttpInfo(String name, Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // verify the required parameter 'name' is set
    if (name == null) {
      throw new BadRequestException("Missing the required parameter 'name' when calling enableFeature");
    }
    // create path and map variables /enable/{name}
    String localVarPath = "/enable/{name}"
      .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<FeatureState> localVarReturnType = new GenericType<FeatureState>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * the features that are enabled. Convenience function for UI.
    * @return List&lt;String&gt;
  */
  public List<String> enabledFeatures() {
    return enabledFeaturesWithHttpInfo().getData();
  }

  /**
  * 
  * the features that are enabled. Convenience function for UI.
    * @return List&lt;String&gt;
  */
  public List<String> enabledFeatures(Map<String, String> extraHeaders) {
    return enabledFeaturesWithHttpInfo(extraHeaders).getData();
  }

  /**
  * 
  * the features that are enabled. Convenience function for UI.
    * @return ApiResponse&lt;List&lt;String&gt;&gt;
  */
  public ApiResponse<List<String>> enabledFeaturesWithHttpInfo() {
      return enabledFeaturesWithHttpInfo(null);

  }

    /**
   * 
   * the features that are enabled. Convenience function for UI.
   * @return ApiResponse&lt;List&lt;String&gt;&gt;
   */
  public ApiResponse<List<String>> enabledFeaturesWithHttpInfo(Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // create path and map variables /enabled
    String localVarPath = "/enabled";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<String>> localVarReturnType = new GenericType<List<String>>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * Gets the details about the feature identified by the name
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState getFeature( @PathParam("name") String name) {
    return getFeatureWithHttpInfo(name).getData();
  }

  /**
  * 
  * Gets the details about the feature identified by the name
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState getFeature( @PathParam("name") String name, Map<String, String> extraHeaders) {
    return getFeatureWithHttpInfo(name, extraHeaders).getData();
  }

  /**
  * 
  * Gets the details about the feature identified by the name
    * @param name the feature name (required)
    * @return ApiResponse&lt;FeatureState&gt;
  */
  public ApiResponse<FeatureState> getFeatureWithHttpInfo(String name) {
      return getFeatureWithHttpInfo(name, null);

  }

    /**
   * 
   * Gets the details about the feature identified by the name
   * @param name the feature name (required)
   * @return ApiResponse&lt;FeatureState&gt;
   */
  public ApiResponse<FeatureState> getFeatureWithHttpInfo(String name, Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // verify the required parameter 'name' is set
    if (name == null) {
      throw new BadRequestException("Missing the required parameter 'name' when calling getFeature");
    }
    // create path and map variables /feature/{name}
    String localVarPath = "/feature/{name}"
      .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<FeatureState> localVarReturnType = new GenericType<FeatureState>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * Locks feature
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState lockFeature( @PathParam("name") String name) {
    return lockFeatureWithHttpInfo(name).getData();
  }

  /**
  * 
  * Locks feature
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState lockFeature( @PathParam("name") String name, Map<String, String> extraHeaders) {
    return lockFeatureWithHttpInfo(name, extraHeaders).getData();
  }

  /**
  * 
  * Locks feature
    * @param name the feature name (required)
    * @return ApiResponse&lt;FeatureState&gt;
  */
  public ApiResponse<FeatureState> lockFeatureWithHttpInfo(String name) {
      return lockFeatureWithHttpInfo(name, null);

  }

    /**
   * 
   * Locks feature
   * @param name the feature name (required)
   * @return ApiResponse&lt;FeatureState&gt;
   */
  public ApiResponse<FeatureState> lockFeatureWithHttpInfo(String name, Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // verify the required parameter 'name' is set
    if (name == null) {
      throw new BadRequestException("Missing the required parameter 'name' when calling lockFeature");
    }
    // create path and map variables /lock/{name}
    String localVarPath = "/lock/{name}"
      .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<FeatureState> localVarReturnType = new GenericType<FeatureState>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * refresh feature states
    * @return String
  */
  public String refresh() {
    return refreshWithHttpInfo().getData();
  }

  /**
  * 
  * refresh feature states
    * @return String
  */
  public String refresh(Map<String, String> extraHeaders) {
    return refreshWithHttpInfo(extraHeaders).getData();
  }

  /**
  * 
  * refresh feature states
    * @return ApiResponse&lt;String&gt;
  */
  public ApiResponse<String> refreshWithHttpInfo() {
      return refreshWithHttpInfo(null);

  }

    /**
   * 
   * refresh feature states
   * @return ApiResponse&lt;String&gt;
   */
  public ApiResponse<String> refreshWithHttpInfo(Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // create path and map variables /refresh
    String localVarPath = "/refresh";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<String> localVarReturnType = new GenericType<String>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
  * 
  * Unlocks feature
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState unlockFeature( @PathParam("name") String name) {
    return unlockFeatureWithHttpInfo(name).getData();
  }

  /**
  * 
  * Unlocks feature
    * @param name the feature name (required)
    * @return FeatureState
  */
  public FeatureState unlockFeature( @PathParam("name") String name, Map<String, String> extraHeaders) {
    return unlockFeatureWithHttpInfo(name, extraHeaders).getData();
  }

  /**
  * 
  * Unlocks feature
    * @param name the feature name (required)
    * @return ApiResponse&lt;FeatureState&gt;
  */
  public ApiResponse<FeatureState> unlockFeatureWithHttpInfo(String name) {
      return unlockFeatureWithHttpInfo(name, null);

  }

    /**
   * 
   * Unlocks feature
   * @param name the feature name (required)
   * @return ApiResponse&lt;FeatureState&gt;
   */
  public ApiResponse<FeatureState> unlockFeatureWithHttpInfo(String name, Map<String, String> extraHeaders) {
    Object localVarPostBody = new Object();
    // verify the required parameter 'name' is set
    if (name == null) {
      throw new BadRequestException("Missing the required parameter 'name' when calling unlockFeature");
    }
    // create path and map variables /unlock/{name}
    String localVarPath = "/unlock/{name}"
      .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (extraHeaders != null) {
      localVarHeaderParams.putAll(extraHeaders);
    }


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<FeatureState> localVarReturnType = new GenericType<FeatureState>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
