/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.openapi;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.languages.DartClientCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartV3ApiGenerator
extends DartClientCodegen
implements CodegenConfig {
    private static final Logger log = LoggerFactory.getLogger(DartV3ApiGenerator.class);
    private static final String LIBRARY_NAME = "dart2-api";
    private static final String DART2_TEMPLATE_FOLDER = "dart2-v3template";

    public DartV3ApiGenerator() {
        this.library = LIBRARY_NAME;
        this.supportedLibraries.clear();
        this.supportedLibraries.put(LIBRARY_NAME, LIBRARY_NAME);
    }

    public String getName() {
        return LIBRARY_NAME;
    }

    public String getHelp() {
        return "dart2 api generator. generates all classes and interfaces with jax-rs annotations with jersey2 extensions as necessary";
    }

    public void processOpts() {
        this.additionalProperties.put("supportDart2", Boolean.TRUE);
        super.processOpts();
        this.templateDir = DART2_TEMPLATE_FOLDER;
        this.embeddedTemplateDir = DART2_TEMPLATE_FOLDER;
        List removeBad = this.supportingFiles.stream().filter(sf -> sf.templateFile.contains("git_push.sh") || sf.templateFile.contains("gitignore") || sf.templateFile.contains("README") || sf.templateFile.contains("travis")).collect(Collectors.toList());
        this.supportingFiles.removeAll(removeBad);
    }

    public String escapeReservedWord(String name) {
        return this.isReservedWord(name) ? name + "_" : name;
    }

    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "empty";
        }
        String var = value;
        if ("number".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) {
            var = "Number" + var;
        }
        return this.escapeReservedWord(var);
    }

    public void postProcessFile(File file, String fileType) {
        String flutterDir = System.getenv("FLUTTER ");
        if (file == null || flutterDir == null) {
            return;
        }
        String dartPostProcessFile = String.format("%s/bin/cache/dart-sdk/bin/dartfmt -w", flutterDir);
        if (StringUtils.isEmpty((CharSequence)dartPostProcessFile)) {
            return;
        }
        if ("dart".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = dartPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    log.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    log.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                log.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

