/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.DFSClientCache;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;

class DFSClientCache {
    private static final Log LOG = LogFactory.getLog(DFSClientCache.class);
    @VisibleForTesting
    final LoadingCache<String, DFSClient> clientCache;
    static final int DEFAULT_DFS_CLIENT_CACHE_SIZE = 256;
    final LoadingCache<DFSInputStreamCaheKey, FSDataInputStream> inputstreamCache;
    static final int DEFAULT_DFS_INPUTSTREAM_CACHE_SIZE = 1024;
    static final int DEFAULT_DFS_INPUTSTREAM_CACHE_TTL = 600;
    private final NfsConfiguration config;
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;

    DFSClientCache(NfsConfiguration config) {
        this(config, 256);
    }

    DFSClientCache(NfsConfiguration config, int clientCache) {
        this.config = config;
        this.clientCache = CacheBuilder.newBuilder().maximumSize((long)clientCache).removalListener(this.clientRemovalListener()).build(this.clientLoader());
        this.inputstreamCache = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterAccess(600L, TimeUnit.SECONDS).removalListener(this.inputStreamRemovalListener()).build(this.inputStreamLoader());
        ShutdownHookManager.get().addShutdownHook((Runnable)new CacheFinalizer(this, null), 10);
    }

    synchronized void closeAll(boolean onlyAutomatic) throws IOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        ConcurrentMap map = this.clientCache.asMap();
        for (Map.Entry item : map.entrySet()) {
            DFSClient client = (DFSClient)item.getValue();
            if (client == null) continue;
            try {
                client.close();
            }
            catch (IOException ioe) {
                exceptions.add(ioe);
            }
        }
        if (!exceptions.isEmpty()) {
            throw MultipleIOException.createIOException(exceptions);
        }
    }

    private CacheLoader<String, DFSClient> clientLoader() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    UserGroupInformation getUserGroupInformation(String effectiveUser, UserGroupInformation realUser) throws IOException {
        Preconditions.checkNotNull((Object)effectiveUser);
        Preconditions.checkNotNull((Object)realUser);
        realUser.checkTGTAndReloginFromKeytab();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)effectiveUser, (UserGroupInformation)realUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Created ugi: %s for username: %s", ugi, effectiveUser));
        }
        return ugi;
    }

    private RemovalListener<String, DFSClient> clientRemovalListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private RemovalListener<DFSInputStreamCaheKey, FSDataInputStream> inputStreamRemovalListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private CacheLoader<DFSInputStreamCaheKey, FSDataInputStream> inputStreamLoader() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    DFSClient getDfsClient(String userName) {
        DFSClient client = null;
        try {
            client = (DFSClient)this.clientCache.get((Object)userName);
        }
        catch (ExecutionException e) {
            LOG.error((Object)("Failed to create DFSClient for user:" + userName + " Cause:" + e));
        }
        return client;
    }

    FSDataInputStream getDfsInputStream(String userName, String inodePath) {
        DFSInputStreamCaheKey k = new DFSInputStreamCaheKey(userName, inodePath, null);
        FSDataInputStream s = null;
        try {
            s = (FSDataInputStream)this.inputstreamCache.get((Object)k);
        }
        catch (ExecutionException e) {
            LOG.warn((Object)("Failed to create DFSInputStream for user:" + userName + " Cause:" + e));
        }
        return s;
    }

    public void invalidateDfsInputStream(String userName, String inodePath) {
        DFSInputStreamCaheKey k = new DFSInputStreamCaheKey(userName, inodePath, null);
        this.inputstreamCache.invalidate((Object)k);
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ NfsConfiguration access$200(DFSClientCache x0) {
        return x0.config;
    }
}

