/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite;

import chat.dim.sql.SQLBuilder;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.DatabaseHandler;
import chat.dim.sqlite.ResultSetExtractor;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class DataTableHandler
extends DatabaseHandler {
    public DataTableHandler(DatabaseConnector sqliteConnector) {
        super(sqliteConnector);
    }

    public boolean createTable(String table, String[] fields) {
        String sql = SQLBuilder.buildCreateTable(table, fields);
        try {
            this.executeUpdate(sql);
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int insert(String table, String[] columns, Object[] values) {
        String sql = SQLBuilder.buildInsert(table, columns, values);
        try {
            return this.executeUpdate(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public <T> List<T> select(String[] columns, String table, SQLConditions conditions, int limit, ResultSetExtractor<T> extractor) {
        String sql = SQLBuilder.buildSelect(columns, table, conditions, null, null, null, limit);
        try {
            return this.executeQuery(sql, extractor);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> List<T> select(String[] columns, String table, SQLConditions conditions, String groupBy, String having, String orderBy, int limit, ResultSetExtractor<T> extractor) {
        String sql = SQLBuilder.buildSelect(columns, table, conditions, groupBy, having, orderBy, limit);
        try {
            return this.executeQuery(sql, extractor);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int update(String table, Map<String, Object> values, SQLConditions conditions) {
        String sql = SQLBuilder.buildUpdate(table, values, conditions);
        try {
            return this.executeUpdate(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int delete(String table, SQLConditions conditions) {
        String sql = SQLBuilder.buildDelete(table, conditions);
        try {
            return this.executeUpdate(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

