/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DatabaseConnector {
    private final String dbFilePath;
    private Connection connection;

    public DatabaseConnector(String sqliteFilePath) {
        this.dbFilePath = sqliteFilePath;
        this.connection = null;
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public void destroy() throws SQLException {
        Connection conn = this.connection;
        if (conn != null) {
            this.connection = null;
            conn.close();
        }
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.connection;
        if (conn == null) {
            this.connection = conn = DriverManager.getConnection("jdbc:sqlite:" + this.dbFilePath);
        }
        return conn;
    }
}

