/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite;

import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.ResultSetExtractor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DatabaseHandler {
    private final DatabaseConnector connector;
    private Statement statement;
    private ResultSet resultSet;

    public DatabaseHandler(DatabaseConnector sqliteConnector) {
        this.connector = sqliteConnector;
        this.statement = null;
        this.resultSet = null;
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public void destroy() throws SQLException {
        ResultSet result;
        Statement stat = this.statement;
        if (stat != null) {
            this.statement = null;
            stat.close();
        }
        if ((result = this.resultSet) != null) {
            this.resultSet = null;
            result.close();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.connector.getConnection();
    }

    public Statement getStatement() throws SQLException {
        Statement stat = this.statement;
        if (stat == null) {
            this.statement = stat = this.getConnection().createStatement();
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> executeQuery(String sql, ResultSetExtractor<T> extractor) throws SQLException {
        ArrayList<T> rows = new ArrayList<T>();
        try {
            this.resultSet = this.getStatement().executeQuery(sql);
            while (this.resultSet.next()) {
                rows.add(extractor.extractRow(this.resultSet, this.resultSet.getRow()));
            }
        }
        finally {
            this.destroy();
        }
        return rows;
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            int n = this.getStatement().executeUpdate(sql);
            return n;
        }
        finally {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String ... sqlList) throws SQLException {
        try {
            for (String sql : sqlList) {
                this.getStatement().executeUpdate(sql);
            }
        }
        finally {
            this.destroy();
        }
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

