/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.UserDBI;
import chat.dim.protocol.ID;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.ResultSetExtractor;
import java.util.ArrayList;
import java.util.List;

public class ContactTable
extends DataTableHandler
implements UserDBI {
    private ResultSetExtractor<ID> extractor = null;

    public ContactTable(DatabaseConnector connector) {
        super(connector);
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "user VARCHAR(64)", "contact VARCHAR(64)", "alias VARCHAR(32))"};
            if (!this.createTable("t_contact", fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                String did = resultSet.getString("contact");
                return ID.parse((Object)did);
            };
        }
        return true;
    }

    public List<ID> getLocalUsers() {
        throw new AssertionError((Object)"call UserTable");
    }

    public boolean saveLocalUsers(List<ID> users) {
        throw new AssertionError((Object)"call UserTable");
    }

    public List<ID> getContacts(ID user) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "user", "=", user.toString());
        String[] columns = new String[]{"contact"};
        return this.select(columns, "t_contact", conditions, 0, this.extractor);
    }

    public boolean saveContacts(List<ID> contacts, ID user) {
        List<ID> oldContacts = this.getContacts(user);
        if (oldContacts == null) {
            oldContacts = new ArrayList<ID>();
        }
        for (ID identifier : oldContacts) {
            if (contacts.contains(identifier)) continue;
            SQLConditions conditions = new SQLConditions();
            conditions.addCondition(null, "user", "=", user.toString());
            conditions.addCondition(SQLConditions.Relation.AND, "contact", "=", identifier.toString());
            if (this.delete("t_contact", conditions) >= 0) continue;
            return false;
        }
        for (ID identifier : contacts) {
            if (oldContacts.contains(identifier)) continue;
            String[] columns = new String[]{"user", "contact"};
            Object[] values = new Object[]{user.toString(), identifier.toString()};
            if (this.insert("t_contact", columns, values) >= 0) continue;
            return false;
        }
        return true;
    }
}

