/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.DocumentDBI;
import chat.dim.protocol.Document;
import chat.dim.protocol.ID;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.ResultSetExtractor;
import java.util.HashMap;
import java.util.List;

public class DocumentTable
extends DataTableHandler
implements DocumentDBI {
    private ResultSetExtractor<Document> extractor = null;

    public DocumentTable(DatabaseConnector connector) {
        super(connector);
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "did VARCHAR(64)", "type VARCHAR(8)", "data TEXT", "signature VARCHAR(88)"};
            if (!this.createTable("t_document", fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                String did = resultSet.getString("did");
                String type = resultSet.getString("type");
                String data = resultSet.getString("data");
                String signature = resultSet.getString("signature");
                assert (did != null && did.length() > 0) : "did error: " + did;
                ID identifier = ID.parse((Object)did);
                if (identifier == null) {
                    throw new AssertionError((Object)("ID error: " + did));
                }
                if (type == null || type.length() == 0) {
                    type = "*";
                }
                Document doc = Document.create((String)type, (ID)identifier, (String)data, (String)signature);
                if (type.equals("*")) {
                    type = identifier.isGroup() ? "bulletin" : "visa";
                }
                doc.put((Object)"type", (Object)type);
                return doc;
            };
        }
        return true;
    }

    public boolean saveDocument(Document doc) {
        ID identifier = doc.getIdentifier();
        String type = doc.getType();
        String data = (String)doc.get((Object)"data");
        String signature = (String)doc.get((Object)"signature");
        Document old = this.getDocument(identifier, type);
        if (old == null) {
            String[] columns = new String[]{"did", "type", "data", "signature"};
            Object[] values = new Object[]{identifier.toString(), type, data, signature};
            return this.insert("t_document", columns, values) > 0;
        }
        if (old.get((Object)"data").equals(data) && old.get((Object)"signature").equals(signature)) {
            return true;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "did", "=", identifier.toString());
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("type", type);
        values.put("data", data);
        values.put("signature", signature);
        return this.update("t_document", values, conditions) > 0;
    }

    public Document getDocument(ID entity, String type) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "did", "=", entity.toString());
        String[] columns = new String[]{"did", "type", "data", "signature"};
        List<Document> results = this.select(columns, "t_document", conditions, null, null, "id DESC", 0, this.extractor);
        return results == null || results.size() == 0 ? null : results.get(0);
    }
}

