/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.MetaDBI;
import chat.dim.format.JSON;
import chat.dim.protocol.ID;
import chat.dim.protocol.Meta;
import chat.dim.protocol.MetaType;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.ResultSetExtractor;
import java.util.HashMap;
import java.util.List;

public class MetaTable
extends DataTableHandler
implements MetaDBI {
    private ResultSetExtractor<Meta> extractor = null;

    public MetaTable(DatabaseConnector connector) {
        super(connector);
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "did VARCHAR(64)", "type INTEGER", "key TEXT", "seed VARCHAR(20)", "fingerprint VARCHAR(88)"};
            if (!this.createTable("t_meta", fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                int type = resultSet.getInt("type");
                String pk = resultSet.getString("key");
                Object key = JSON.decode((String)pk);
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("version", type);
                info.put("type", type);
                info.put("key", key);
                if (MetaType.hasSeed((int)type)) {
                    String seed = resultSet.getString("seed");
                    String ct = resultSet.getString("fingerprint");
                    info.put("seed", seed);
                    info.put("fingerprint", ct);
                }
                return Meta.parse(info);
            };
        }
        return true;
    }

    public boolean saveMeta(Meta meta, ID entity) {
        String ct;
        String seed;
        Meta old = this.getMeta(entity);
        if (old != null) {
            return false;
        }
        int type = meta.getType();
        String pk = JSON.encode((Object)meta.getKey());
        if (MetaType.hasSeed((int)type)) {
            seed = meta.getSeed();
            ct = (String)meta.get((Object)"fingerprint");
        } else {
            seed = "";
            ct = "";
        }
        String[] columns = new String[]{"did", "type", "key", "seed", "fingerprint"};
        Object[] values = new Object[]{entity.toString(), type, pk, seed, ct};
        return this.insert("t_meta", columns, values) > 0;
    }

    public Meta getMeta(ID entity) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "did", "=", entity.toString());
        String[] columns = new String[]{"type", "key", "seed", "fingerprint"};
        List<Meta> results = this.select(columns, "t_meta", conditions, null, null, "id DESC", 0, this.extractor);
        return results == null || results.size() == 0 ? null : results.get(0);
    }
}

