/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.crypto.DecryptKey;
import chat.dim.crypto.PrivateKey;
import chat.dim.dbi.PrivateKeyDBI;
import chat.dim.format.JSON;
import chat.dim.protocol.ID;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.ResultSetExtractor;
import java.util.List;

public class PrivateKeyTable
extends DataTableHandler
implements PrivateKeyDBI {
    private ResultSetExtractor<PrivateKey> extractor = null;

    public PrivateKeyTable(DatabaseConnector connector) {
        super(connector);
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "user VARCHAR(64)", "key TEXT", "type CHAR(1)", "sign BIT", "decrypt BIT"};
            if (!this.createTable("t_private_key", fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                String sk = resultSet.getString("key");
                Object key = JSON.decode((String)sk);
                return PrivateKey.parse((Object)key);
            };
        }
        return true;
    }

    private boolean savePrivateKey(ID user, PrivateKey key, String type, int sign, int decrypt) {
        if (!this.prepare()) {
            return false;
        }
        String pk = JSON.encode((Object)key);
        String[] columns = new String[]{"user", "key", "type", "sign", "decrypt"};
        Object[] values = new Object[]{user.toString(), pk, type, sign, decrypt};
        return this.insert("t_private_key", columns, values) > 0;
    }

    public boolean savePrivateKey(PrivateKey key, String type, ID user) {
        if (key instanceof DecryptKey) {
            return this.savePrivateKey(user, key, type, 1, 1);
        }
        return this.savePrivateKey(user, key, type, 1, 0);
    }

    public List<DecryptKey> getPrivateKeysForDecryption(ID user) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "user", "=", user.toString());
        conditions.addCondition(SQLConditions.Relation.AND, "decrypt", "=", 1);
        String[] columns = new String[]{"key"};
        List<PrivateKey> results = this.select(columns, "t_private_key", conditions, null, null, "type DESC", 0, this.extractor);
        if (results == null) {
            return null;
        }
        return PrivateKeyDBI.convertDecryptKeys(results);
    }

    public PrivateKey getPrivateKeyForSignature(ID user) {
        return this.getPrivateKeyForVisaSignature(user);
    }

    public PrivateKey getPrivateKeyForVisaSignature(ID user) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "user", "=", user.toString());
        conditions.addCondition(SQLConditions.Relation.AND, "type", "=", "M");
        conditions.addCondition(SQLConditions.Relation.AND, "sign", "=", 1);
        String[] columns = new String[]{"key"};
        List<PrivateKey> results = this.select(columns, "t_private_key", conditions, null, null, "type DESC", 0, this.extractor);
        return results == null || results.size() == 0 ? null : results.get(0);
    }
}

