/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.UserDBI;
import chat.dim.protocol.ID;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.ResultSetExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UserTable
extends DataTableHandler
implements UserDBI {
    private ResultSetExtractor<ID> extractor = null;

    public UserTable(DatabaseConnector connector) {
        super(connector);
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "user VARCHAR(64)", "chosen BIT"};
            if (!this.createTable("t_local_user", fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                String user = resultSet.getString("user");
                return ID.parse((Object)user);
            };
        }
        return true;
    }

    public List<ID> getLocalUsers() {
        if (!this.prepare()) {
            return null;
        }
        String[] columns = new String[]{"user"};
        return this.select(columns, "t_local_user", null, null, null, "chosen DESC", 0, this.extractor);
    }

    public boolean saveLocalUsers(List<ID> users) {
        HashMap<String, Object> values;
        SQLConditions conditions;
        List<ID> localUsers = this.getLocalUsers();
        if (localUsers == null) {
            localUsers = new ArrayList<ID>();
        }
        for (ID identifier : localUsers) {
            if (users.contains(identifier)) continue;
            conditions = new SQLConditions();
            conditions.addCondition(null, "user", "=", identifier.toString());
            if (this.delete("t_local_user", conditions) >= 0) continue;
            return false;
        }
        for (ID identifier : users) {
            if (localUsers.contains(identifier)) continue;
            String[] columns = new String[]{"user", "chosen"};
            Object[] values2 = new Object[]{identifier.toString(), 0};
            if (this.insert("t_local_user", columns, values2) >= 0) continue;
            return false;
        }
        if (users.size() == 0) {
            return true;
        }
        ID first = users.get(0);
        if (localUsers.size() == 0 || !localUsers.get(0).equals(first)) {
            values = new HashMap<String, Object>();
            values.put("chosen", 0);
            if (this.update("t_local_user", values, null) < 0) {
                return false;
            }
        }
        values = new HashMap();
        values.put("chosen", 1);
        conditions = new SQLConditions();
        conditions.addCondition(null, "user", "=", first.toString());
        return this.update("t_local_user", values, null) > 0;
    }

    public List<ID> getContacts(ID user) {
        throw new AssertionError((Object)"call ContactTable");
    }

    public boolean saveContacts(List<ID> contacts, ID user) {
        throw new AssertionError((Object)"call ContactTable");
    }
}

