/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.dao;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.db.SessionUtil;
import cloud.agileframework.data.common.dao.BaseDao;
import cloud.agileframework.data.common.dao.ColumnName;
import cloud.agileframework.data.common.dictionary.DataExtendManager;
import com.alibaba.druid.DbType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.MappingElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.SimpleElasticsearchRepository;
import org.springframework.data.repository.PagingAndSortingRepository;

public class ElasticsearchDao
implements BaseDao {
    private final ElasticsearchRestTemplate restTemplate;
    private final ConnectionPoolDataSource connectionPoolDataSource;
    @Autowired
    private DataExtendManager dataExtendManager;

    public ElasticsearchDao(ElasticsearchRestTemplate restTemplate, ConnectionPoolDataSource connectionPoolDataSource) {
        this.restTemplate = restTemplate;
        this.connectionPoolDataSource = connectionPoolDataSource;
    }

    public DataExtendManager dictionaryManager() {
        return this.dataExtendManager;
    }

    public <T, ID> PagingAndSortingRepository<T, ID> getRepository(Class<T> tableClass) {
        PagingAndSortingRepository pagingAndSortingRepository = (PagingAndSortingRepository)REPOSITORY_CACHE.get(tableClass);
        if (pagingAndSortingRepository != null) {
            return pagingAndSortingRepository;
        }
        pagingAndSortingRepository = new SimpleElasticsearchRepository((ElasticsearchEntityInformation)new MappingElasticsearchEntityInformation((ElasticsearchPersistentEntity)this.restTemplate.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(tableClass)), (ElasticsearchOperations)this.restTemplate);
        REPOSITORY_CACHE.put(tableClass, pagingAndSortingRepository);
        return pagingAndSortingRepository;
    }

    public Connection getConnection() {
        return this.connectionPoolDataSource.getPooledConnection().getConnection();
    }

    public <T> Page<T> page(T object, PageRequest pageRequest) {
        if (object instanceof Class) {
            throw new IllegalArgumentException("Parameter must be of type POJO");
        }
        if (object == null) {
            return Page.empty();
        }
        List<?> content = this.findBySQL(this.toPageSQL(object, pageRequest, DbType.mysql), object.getClass(), Maps.newHashMap());
        this.dictionaryManager().cover(content);
        Long total = (Long)this.findOne(this.toPageCountSQL(object, pageRequest, DbType.mysql), Long.TYPE, new Object[]{Maps.newHashMap()});
        return new PageImpl(content, (Pageable)pageRequest, total.longValue());
    }

    public <T> Page<T> pageBySQL(String sql, PageRequest pageable, Class<T> clazz, Object ... parameters) {
        List content = Lists.newArrayList();
        long total = 0L;
        int page = pageable.getPageNumber();
        int size = pageable.getPageSize();
        try (Connection connection = this.getConnection();){
            if (parameters == null || parameters.length == 0) {
                content = SessionUtil.limit((Connection)connection, (String)sql, clazz, (int)(size * page), (int)size);
                this.dictionaryManager().cover((Object)content);
                total = SessionUtil.count((Connection)connection, (String)sql);
            } else {
                content = SessionUtil.limit((Connection)connection, (String)sql, clazz, (Object)parameters[0], (int)(size * page), (int)size);
                this.dictionaryManager().cover((Object)content);
                total = SessionUtil.count((Connection)connection, (String)sql, (Object)parameters[0]);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new PageImpl(content, (Pageable)pageable, total);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> findBySQL(String sql, Class<T> clazz, Object ... parameters) {
        try (Connection connection = this.getConnection();){
            if (parameters == null || parameters.length == 0) {
                List list2 = SessionUtil.query((Connection)connection, (String)sql, clazz);
                return list2;
            }
            List content = SessionUtil.query((Connection)connection, (String)sql, clazz, (Object)parameters[0]);
            this.dictionaryManager().cover((Object)content);
            List list = content;
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Lists.newArrayList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> findBySQL(String sql, Class<T> clazz, Integer firstResult, Integer maxResults, Object ... parameters) {
        if (maxResults <= firstResult) {
            throw new IllegalArgumentException("maxResults must Greater than or equal to firstResult");
        }
        try (Connection connection = this.getConnection();){
            if (parameters == null || parameters.length == 0) {
                List list2 = SessionUtil.limit((Connection)connection, (String)sql, clazz, (int)firstResult, (int)(maxResults - firstResult));
                return list2;
            }
            List content = SessionUtil.limit((Connection)connection, (String)sql, clazz, (Object)parameters[0], (int)firstResult, (int)(maxResults - firstResult));
            this.dictionaryManager().cover((Object)content);
            List list = content;
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Lists.newArrayList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> findBySQL(String sql, Object ... parameters) {
        try (Connection connection = this.getConnection();){
            if (parameters == null || parameters.length == 0) {
                List list2 = SessionUtil.query((Connection)connection, (String)sql);
                return list2;
            }
            List list = SessionUtil.query((Connection)connection, (String)sql, (Object)parameters[0]);
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Lists.newArrayList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateBySQL(String sql, Object ... parameters) {
        try (Connection connection = this.getConnection();){
            if (parameters == null || parameters.length == 0) {
                int n2 = SessionUtil.update((Connection)connection, (String)sql);
                return n2;
            }
            int n = SessionUtil.update((Connection)connection, (String)sql, (Object)parameters[0]);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public <T> List<ColumnName> toColumnNames(Class<T> tableClass) {
        return ClassUtil.getAllEntityAnnotation(tableClass, Field.class).stream().map(f -> {
            ColumnName columnName = new ColumnName();
            Field annotation = (Field)f.getAnnotation();
            String value = annotation.value();
            String name = annotation.name();
            if (!StringUtils.isEmpty((CharSequence)value)) {
                columnName.setName(value);
            }
            if (!StringUtils.isEmpty((CharSequence)name)) {
                columnName.setName(name);
            }
            columnName.setMember(f.getMember());
            Id id = (Id)ClassUtil.getFieldAnnotation((Class)tableClass, (String)columnName.getName(), Id.class);
            columnName.setPrimaryKey(id != null);
            return columnName;
        }).collect(Collectors.toList());
    }

    public <T> String toTableName(Class<T> tableClass) {
        Document document = tableClass.getAnnotation(Document.class);
        return document.indexName();
    }

    public <T> void batchInsert(List<T> list, int batchSize) {
        List sqls = list.stream().map(s -> this.toInsertSql(s, DbType.mysql)).collect(Collectors.toList());
        try (Connection connection = this.getConnection();){
            SessionUtil.batchUpdate((Connection)connection, sqls);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

