/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch;

import cloud.agileframework.elasticsearch.ConnectionEnhanceImpl;
import cloud.agileframework.elasticsearch.protocol.EnhanceProtocol;
import cloud.agileframework.elasticsearch.proxy.JdbcRequest;
import cloud.agileframework.elasticsearch.proxy.JdbcResponse;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.amazon.opendistroforelasticsearch.jdbc.ConnectionImpl;
import com.amazon.opendistroforelasticsearch.jdbc.PreparedStatementImpl;
import com.amazon.opendistroforelasticsearch.jdbc.logging.Logger;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.exceptions.ResponseException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class AgilePreparedStatement
extends PreparedStatementImpl {
    private final ConnectionEnhanceImpl connection;
    private final List<SQLStatement> batch = Lists.newArrayList();

    public AgilePreparedStatement(ConnectionEnhanceImpl connection, String sql, Logger log) throws SQLException {
        super((ConnectionImpl)connection, sql, log);
        this.connection = connection;
    }

    public int executeUpdate() throws SQLException {
        this.closeResultSet(false);
        try {
            JdbcResponse response = ((EnhanceProtocol)this.connection.getProtocol()).executeUpdate(JdbcRequest.of(this.sql));
            return response.count();
        }
        catch (ResponseException | IOException ex) {
            this.logAndThrowSQLException(this.log, new SQLException("Error executing query", ex));
            return 0;
        }
    }

    public int[] executeBatch() throws SQLException {
        this.closeResultSet(false);
        try {
            JdbcResponse response = ((EnhanceProtocol)this.connection.getProtocol()).executeUpdate(JdbcRequest.of(this.batch));
            return response.counts();
        }
        catch (ResponseException | IOException ex) {
            this.logAndThrowSQLException(this.log, new SQLException("Error executing query", ex));
            this.clearBatch();
            return new int[0];
        }
    }

    public void addBatch(String sql) throws SQLException {
        SQLStatement statement = JdbcRequest.to(sql);
        if (statement instanceof SQLInsertStatement) {
            this.batch.add(statement);
        }
        super.addBatch(sql);
    }

    public void clearBatch() {
        this.batch.clear();
    }
}

