/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch;

import cloud.agileframework.elasticsearch.ConnectionEnhanceImpl;
import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionConfig;
import com.amazon.opendistroforelasticsearch.jdbc.logging.LogLevel;
import com.amazon.opendistroforelasticsearch.jdbc.logging.Logger;
import com.amazon.opendistroforelasticsearch.jdbc.logging.LoggerFactory;
import com.amazon.opendistroforelasticsearch.jdbc.logging.NoOpLogger;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class Driver
extends com.amazon.opendistroforelasticsearch.jdbc.Driver
implements java.sql.Driver {
    public static final String URL_PREFIX = "jdbc:elastic://";

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.startsWith(URL_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        url = url.replace(URL_PREFIX, "jdbc:elasticsearch://");
        ConnectionConfig connectionConfig = ConnectionConfig.builder().setUrl(url).setProperties(info).build();
        Logger log = Driver.initLog(connectionConfig);
        log.debug(String.format("connect (%s, %s)", url, info == null ? "null" : info.toString()));
        log.debug(String.format("Opening connection using config: %s", connectionConfig));
        return new ConnectionEnhanceImpl(connectionConfig, log);
    }

    static Logger initLog(ConnectionConfig connectionConfig) {
        if (connectionConfig.getLogWriter() != null) {
            return LoggerFactory.getLogger((PrintWriter)connectionConfig.getLogWriter(), (LogLevel)connectionConfig.getLogLevel());
        }
        if (connectionConfig.getLogOutput() != null) {
            return LoggerFactory.getLogger((String)connectionConfig.getLogOutput(), (LogLevel)connectionConfig.getLogLevel());
        }
        if (DriverManager.getLogWriter() != null) {
            return LoggerFactory.getLogger((PrintWriter)DriverManager.getLogWriter(), (LogLevel)connectionConfig.getLogLevel());
        }
        return NoOpLogger.INSTANCE;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException E) {
            throw new RuntimeException("Can't register driver!");
        }
    }
}

