/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.config;

import cloud.agileframework.common.util.http.HttpUtil;
import cloud.agileframework.elasticsearch.dao.ElasticsearchDao;
import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.sql.ConnectionPoolDataSource;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.elasticsearch.ReactiveElasticsearchRestClientProperties;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.RestClients;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;

@EnableConfigurationProperties(value={ElasticsearchProperties.class, ReactiveElasticsearchRestClientProperties.class})
@Configuration
public class ElasticsearchDaoAutoConfiguration {
    @Bean
    public static ConnectionPoolDataSource connectionPoolDataSource(ElasticsearchProperties properties) {
        DruidDataSource dataSource = new DruidDataSource();
        List urls = properties.getUris().stream().map(s -> s.startsWith("http") ? s : "http://" + s).map(URI::create).collect(Collectors.toList());
        dataSource.setUrl(String.format("jdbc:elastic://%s:%s", ((URI)urls.get(0)).getHost(), ((URI)urls.get(0)).getPort()));
        if ("https".equals(((URI)urls.get(0)).getScheme())) {
            Properties prop = new Properties();
            prop.put("useSSL", "true");
            prop.put("trustSelfSigned", "true");
            dataSource.setConnectProperties(prop);
        }
        dataSource.setDriverClassName("cloud.agileframework.elasticsearch.Driver");
        dataSource.setUsername(properties.getUsername());
        dataSource.setPassword(properties.getPassword());
        dataSource.setValidationQuery("SHOW tables LIKE %");
        dataSource.setInitialSize(10);
        dataSource.setMaxActive(30);
        dataSource.setMinIdle(10);
        dataSource.setMaxWait(2000L);
        dataSource.setPoolPreparedStatements(true);
        dataSource.setMaxOpenPreparedStatements(20);
        return dataSource;
    }

    @Bean
    @ConditionalOnMissingBean(value={RestHighLevelClient.class})
    public RestHighLevelClient restHighLevelClient(ElasticsearchProperties properties) throws NoSuchAlgorithmException, KeyManagementException {
        boolean ssl = false;
        ArrayList list = Lists.newArrayList();
        for (String uriString : properties.getUris()) {
            URI uri = URI.create(uriString);
            list.add(InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort()));
            if (!"https".equals(uri.getScheme())) continue;
            ssl = true;
        }
        ClientConfiguration.MaybeSecureClientConfigurationBuilder builder = ClientConfiguration.builder().connectedTo(list.toArray(new InetSocketAddress[0]));
        if (ssl) {
            builder.usingSsl(HttpUtil.createIgnoreVerifySSL((String)"SSL"), (HostnameVerifier)NoopHostnameVerifier.INSTANCE).withBasicAuth(properties.getUsername(), properties.getPassword());
        }
        return RestClients.create((ClientConfiguration)builder.build()).rest();
    }

    @Bean
    @ConditionalOnMissingBean(value={ElasticsearchRestTemplate.class})
    public ElasticsearchRestTemplate elasticsearchRestTemplate(@Autowired RestHighLevelClient restHighLevelClient) {
        return new ElasticsearchRestTemplate(restHighLevelClient);
    }

    @Bean
    public ElasticsearchDao elasticsearchDao(ElasticsearchRestTemplate restTemplate, ConnectionPoolDataSource connectionPoolDataSource) {
        return new ElasticsearchDao(restTemplate, connectionPoolDataSource);
    }
}

