/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.protocol;

import cloud.agileframework.elasticsearch.protocol.EnhanceProtocol;
import cloud.agileframework.elasticsearch.proxy.JdbcRequest;
import cloud.agileframework.elasticsearch.proxy.JdbcResponse;
import cloud.agileframework.elasticsearch.transport.EnhanceHttpTransport;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.exceptions.ResponseException;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.http.JsonHttpProtocol;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.HttpParam;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.HttpTransport;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.HttpResponse;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class JsonCursorEnhanceHttpProtocol
extends JsonHttpProtocol
implements EnhanceProtocol {
    private final EnhanceHttpTransport transport;

    public JsonCursorEnhanceHttpProtocol(EnhanceHttpTransport transport) {
        super((HttpTransport)transport);
        this.transport = transport;
    }

    public EnhanceHttpTransport getEnhanceTransport() {
        return this.transport;
    }

    @Override
    public JdbcResponse executeUpdate(JdbcRequest request) throws ResponseException, IOException {
        switch (request.getMethod()) {
            case PUT: {
                try (CloseableHttpResponse response = this.getEnhanceTransport().doPut(request.getUrl(), defaultJsonHeaders, new HttpParam[0], request.getBody(), 0);){
                    JdbcResponse jdbcResponse = (JdbcResponse)this.getJsonHttpResponseHandler().handleResponse((HttpResponse)response, contentStream -> request.getHandler().toResponse((InputStream)contentStream));
                    return jdbcResponse;
                }
            }
            case POST: {
                try (CloseableHttpResponse response = this.getEnhanceTransport().doPost(request.getUrl(), defaultJsonHeaders, new HttpParam[0], request.getBody(), 0);){
                    JdbcResponse jdbcResponse = (JdbcResponse)this.getJsonHttpResponseHandler().handleResponse((HttpResponse)response, (Set)Sets.newHashSet((Object[])new Integer[]{200, 201, 204}), true, contentStream -> request.getHandler().toResponse((InputStream)contentStream));
                    return jdbcResponse;
                }
            }
            case DELETE: {
                try (CloseableHttpResponse response = this.getEnhanceTransport().doDelete(request.getUrl(), defaultJsonHeaders, new HttpParam[0], 0);){
                    JdbcResponse jdbcResponse = (JdbcResponse)this.getJsonHttpResponseHandler().handleResponse((HttpResponse)response, contentStream -> request.getHandler().toResponse((InputStream)contentStream));
                    return jdbcResponse;
                }
            }
        }
        try (CloseableHttpResponse response = this.getEnhanceTransport().doGet(request.getUrl(), defaultJsonHeaders, new HttpParam[0], 0);){
            JdbcResponse jdbcResponse = (JdbcResponse)this.getJsonHttpResponseHandler().handleResponse((HttpResponse)response, contentStream -> request.getHandler().toResponse((InputStream)contentStream));
            return jdbcResponse;
        }
    }
}

