/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.proxy;

import cloud.agileframework.common.util.http.RequestMethod;
import cloud.agileframework.elasticsearch.proxy.SqlParseProvider;
import cloud.agileframework.elasticsearch.proxy.batch.BatchHandler;
import cloud.agileframework.elasticsearch.proxy.create.CreateHandler;
import cloud.agileframework.elasticsearch.proxy.delete.DeleteHandler;
import cloud.agileframework.elasticsearch.proxy.insert.InsertHandler;
import cloud.agileframework.elasticsearch.proxy.update.UpdateHandler;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.google.common.collect.Sets;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Set;

public class JdbcRequest {
    private static Set<SqlParseProvider<?, ?>> handlers = Sets.newHashSet((Object[])new SqlParseProvider[]{new CreateHandler(), new InsertHandler(), new UpdateHandler(), new DeleteHandler(), new BatchHandler()});
    private String url;
    private RequestMethod method;
    private String body;
    private SqlParseProvider handler;
    private String index;

    public static JdbcRequest of(String sql) throws SQLFeatureNotSupportedException {
        SQLStatement sqlStatement = JdbcRequest.to(sql);
        for (SqlParseProvider<?, ?> handler : handlers) {
            JdbcRequest request;
            if (!handler.accept(sqlStatement) || (request = handler.of(sqlStatement)) == null) continue;
            return request;
        }
        throw new SQLFeatureNotSupportedException(sql);
    }

    public static JdbcRequest of(List<SQLStatement> sqls) throws SQLFeatureNotSupportedException {
        for (SqlParseProvider<?, ?> handler : handlers) {
            try {
                JdbcRequest request = handler.of(sqls);
                if (request == null) continue;
                return request;
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            }
        }
        throw new SQLFeatureNotSupportedException();
    }

    public static SQLStatement to(String sql) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)DbType.elastic_search);
        SQLStatement statement = parser.parseStatement();
        SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor((DbType)DbType.elastic_search);
        statement.accept((SQLASTVisitor)visitor);
        return statement;
    }

    public String getUrl() {
        if (!this.url.startsWith("/")) {
            this.url = "/" + this.url;
        }
        return this.url;
    }

    JdbcRequest(String url, RequestMethod method, String body, SqlParseProvider handler, String index) {
        this.url = url;
        this.method = method;
        this.body = body;
        this.handler = handler;
        this.index = index;
    }

    public static JdbcRequestBuilder builder() {
        return new JdbcRequestBuilder();
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public String getBody() {
        return this.body;
    }

    public SqlParseProvider getHandler() {
        return this.handler;
    }

    public String getIndex() {
        return this.index;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(RequestMethod method) {
        this.method = method;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setHandler(SqlParseProvider handler) {
        this.handler = handler;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcRequest)) {
            return false;
        }
        JdbcRequest other = (JdbcRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        RequestMethod this$method = this.getMethod();
        RequestMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        SqlParseProvider this$handler = this.getHandler();
        SqlParseProvider other$handler = other.getHandler();
        if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        return !(this$index == null ? other$index != null : !this$index.equals(other$index));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        RequestMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        SqlParseProvider $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcRequest(url=" + this.getUrl() + ", method=" + this.getMethod() + ", body=" + this.getBody() + ", handler=" + this.getHandler() + ", index=" + this.getIndex() + ")";
    }

    public static class JdbcRequestBuilder {
        private String url;
        private RequestMethod method;
        private String body;
        private SqlParseProvider handler;
        private String index;

        JdbcRequestBuilder() {
        }

        public JdbcRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public JdbcRequestBuilder method(RequestMethod method) {
            this.method = method;
            return this;
        }

        public JdbcRequestBuilder body(String body) {
            this.body = body;
            return this;
        }

        public JdbcRequestBuilder handler(SqlParseProvider handler) {
            this.handler = handler;
            return this;
        }

        public JdbcRequestBuilder index(String index) {
            this.index = index;
            return this;
        }

        public JdbcRequest build() {
            return new JdbcRequest(this.url, this.method, this.body, this.handler, this.index);
        }

        public String toString() {
            return "JdbcRequest.JdbcRequestBuilder(url=" + this.url + ", method=" + this.method + ", body=" + this.body + ", handler=" + this.handler + ", index=" + this.index + ")";
        }
    }
}

