/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.proxy.update;

import cloud.agileframework.common.util.http.RequestMethod;
import cloud.agileframework.elasticsearch.proxy.JdbcRequest;
import cloud.agileframework.elasticsearch.proxy.SqlParseProvider;
import cloud.agileframework.elasticsearch.proxy.common.WhereSQLUtil;
import cloud.agileframework.elasticsearch.proxy.update.UpdateResponse;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastjson.JSONObject;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.stream.Collectors;

public class UpdateHandler
implements SqlParseProvider<UpdateResponse, SQLUpdateStatement> {
    @Override
    public JdbcRequest of(SQLUpdateStatement statement) throws SQLFeatureNotSupportedException {
        SQLExpr where = statement.getWhere();
        String index = statement.getTableName().toString();
        JSONObject body = new JSONObject();
        body.put("script", (Object)this.to(statement.getItems()));
        body.put("query", (Object)WhereSQLUtil.to(this, where));
        return JdbcRequest.builder().handler(this).method(RequestMethod.POST).url(index + "/_update_by_query").index(index).body(body.toJSONString()).build();
    }

    public JSONObject to(List<SQLUpdateSetItem> items) {
        JSONObject script = new JSONObject();
        String inline = items.stream().map(item -> {
            String columnName = SQLUtils.toSQLString((SQLObject)item.getColumn());
            return "ctx._source." + columnName + "=params." + columnName;
        }).collect(Collectors.joining(";"));
        script.put("inline", (Object)inline);
        JSONObject params = new JSONObject();
        items.forEach(item -> {
            String column = SQLUtils.toSQLString((SQLObject)item.getColumn());
            SQLExpr v = item.getValue();
            Object value = v instanceof SQLValuableExpr ? ((SQLValuableExpr)v).getValue() : SQLUtils.toSQLString((SQLObject)v);
            params.put(column, value);
        });
        script.put("params", (Object)params);
        script.put("lang", (Object)"painless");
        return script;
    }
}

