/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch;

import cloud.agileframework.elasticsearch.BaseStatement;
import cloud.agileframework.elasticsearch.ConnectionEnhanceImpl;
import cloud.agileframework.elasticsearch.proxy.JdbcRequest;
import cloud.agileframework.elasticsearch.proxy.JdbcResponse;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class AgileStatement
extends BaseStatement {
    private final List<SQLStatement> batch = Lists.newArrayList();

    public AgileStatement(ConnectionEnhanceImpl connection) {
        super(connection);
    }

    public List<SQLStatement> getBatch() {
        return this.batch;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        JdbcResponse result;
        this.checkOpen();
        try {
            result = JdbcRequest.send(sql, this);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return result.count();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        JdbcResponse result;
        this.checkOpen();
        try {
            result = JdbcRequest.send(sql, this);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return result.success();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        JdbcResponse result;
        this.checkOpen();
        try {
            result = JdbcRequest.send(sql, this);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return result.resultSet();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        JdbcResponse result;
        this.checkOpen();
        try {
            result = JdbcRequest.of(this.batch, (BaseStatement)this).send();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.clearBatch();
        return result.counts();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        SQLStatement statement = JdbcRequest.to(sql);
        if (statement instanceof SQLInsertStatement) {
            this.batch.add(statement);
        }
    }

    @Override
    public void clearBatch() {
        this.batch.clear();
    }

    @Override
    protected void checkOpen() throws SQLException {
        if (!this.getConnection().getRestClient().isRunning()) {
            throw new SQLException("statement is closed");
        }
    }
}

