/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch;

import cloud.agileframework.elasticsearch.ConnectionEnhanceImpl;
import cloud.agileframework.elasticsearch.proxy.JdbcRequest;
import cloud.agileframework.elasticsearch.proxy.JdbcResponse;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;

public abstract class BaseStatement
implements Statement {
    private ConnectionEnhanceImpl connection;
    private int fetchDirection;
    private int fetchSize;
    private int resultSetType;
    private int resultSetConcurrency;
    private int resultSetHoldability;
    private int maxFieldSize;
    private int maxRows;
    private int queryTimeout;
    private boolean escapeProcessing;
    private String cursorName;
    private SQLWarning warnings;
    private int updateCount;
    protected boolean closed = false;
    private boolean poolable;
    protected ResultSet generatedKeys;
    protected ResultSet resultSet;

    public BaseStatement(ConnectionEnhanceImpl connection) {
        this.connection = connection;
    }

    @Override
    public ConnectionEnhanceImpl getConnection() throws SQLException {
        return this.connection;
    }

    public void setConnection(ConnectionEnhanceImpl connection) {
        this.connection = connection;
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException();
        }
        if (this.connection != null && this.connection.isClosed()) {
            throw new SQLException("connection is closed");
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this.resultSetType;
    }

    public void setResultSetType(int resultType) {
        this.resultSetType = resultType;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this.escapeProcessing = enable;
    }

    public boolean isEscapeProcessing() {
        return this.escapeProcessing;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        this.queryTimeout = seconds;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        this.cursorName = name;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.warnings = null;
    }

    public void setWarning(SQLWarning warning) {
        this.warnings = warning;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this.updateCount;
    }

    public void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == null) {
            return false;
        }
        return iface == this.getClass() || iface.isInstance(this);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return this.poolable;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
        this.poolable = poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        return this.generatedKeys;
    }

    public void setGeneratedKeys(ResultSet generatedKeys) {
        this.generatedKeys = generatedKeys;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.resultSet;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return new int[0];
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        return false;
    }

    public void setWarnings(SQLWarning warnings) {
        this.warnings = warnings;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        JdbcResponse result;
        this.checkOpen();
        try {
            result = JdbcRequest.send(sql, this);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return result.resultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        JdbcResponse result;
        this.checkOpen();
        try {
            result = JdbcRequest.send(sql, this);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return result.count();
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
    }
}

