/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch;

import cloud.agileframework.elasticsearch.AgileResultSet;
import cloud.agileframework.elasticsearch.types.ElasticsearchType;
import java.sql.SQLFeatureNotSupportedException;

public class ColumnMetaData {
    private String name;
    private String label;
    private String tableSchemaName;
    private int precision = -1;
    private int scale = -1;
    private String tableName;
    private String catalogName;
    private String esTypeName;
    private ElasticsearchType esType;

    public ColumnMetaData(AgileResultSet.Column descriptor) throws SQLFeatureNotSupportedException {
        this.name = descriptor.getName();
        this.label = descriptor.getLabel() == null ? this.name : descriptor.getLabel();
        this.esTypeName = descriptor.getType();
        this.esType = ElasticsearchType.fromTypeName(this.esTypeName);
        this.precision = this.esType.getPrecision();
        this.scale = 0;
        this.tableName = "";
        this.catalogName = "";
        this.tableSchemaName = "";
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTableSchemaName() {
        return this.tableSchemaName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public ElasticsearchType getEsType() {
        return this.esType;
    }

    public String getEsTypeName() {
        return this.esTypeName;
    }
}

